import csv

metrics = [
    ('{\sc cmchar}', 'Mean comment size', 'McommentSize'),
    ('{\sc dcmchar}', 'Comment character density', 'DcommentChar'),   
    ('{\sc dcm}', 'Comment density', 'Dcomment'),
    ('{\sc dconst}', 'const keyword density', 'Dconst'),
    ('{\sc dcpif}', 'C preprocessor conditional statement density', 'CcppConditional'),
    ('{\sc dcpinc}', 'C preprocessor include statement density', 'DcppInclude'),
    ('{\sc dcpstmt}', 'C preprocessor non-include statement density', 'DcppNoInclude'),
    ('{\sc denum}', 'enum keyword density', 'Denum'),
    ('{\sc dgoto}', 'goto keyword density', 'Dgoto'),
    ('{\sc dinl}', 'inline keyword density', 'Dinline'),
    ('{\sc dkludge}', 'Kludge word density', 'Dkludge'),
    ('{\sc dnoal}', 'noalias keyword density', 'Dnoalias'),
    ('{\sc dreg}', 'register keyword density', 'Dregister'),
    ('{\sc drest}', 'restrict keyword density', 'Drestrict'),    
    ('{\sc dsign}', 'signed keyword density', 'Dsigned'),
    ('{\sc dstatic}', 'Internally visible declaration density', 'Dinternal'),
    ('{\sc dstmt}', 'Statement density', 'Dstatement'),
    ('{\sc duns}', 'unsigned keyword density', 'Dunsigned'),
    ('{\sc dvoid}', 'void keyword density', 'Dvoid'),
    ('{\sc dvol}', 'volatile keyword density', 'Dvolatile'),
    ('{\sc filine}', 'Mean file length (lines)', 'MfileLen'),
    ('{\sc fistmt}', 'Mean file functionality (statements)', 'MfileStatement'),
    ('{\sc fminc}', 'Formatting inconsistency', 'Inconsistency'),
    ('{\sc fuline}', 'Mean function length (lines)', 'MfunLen'),
    ('{\sc idchar}', 'Mean identifier length', 'MidentifierLength'),
    ('{\sc indev}', 'Indentation spaces standard deviation', 'SDindentation'),
    ('{\sc inspc}', 'Mean indentation spaces', 'MindentationSpace'),
    ('{\sc lichar}', 'Mean line length (characters)', 'MlineLen'), 
    ('{\sc stnest}', 'Mean statement nesting', 'Mnesting'),
]

summary = {}

with open('analysis-summary.csv') as analysis_summary_file:
    reader = csv.reader(analysis_summary_file)
    for row in reader:
        summary[row[1]] = row[-1]

print r'{\setlength{\tabcolsep}{0pt}'        
print r'\begin{tabular}{ccccc}'
for index, metric in enumerate(metrics):
    print (r'\shortstack{\includegraphics[scale=.20]{../analysis/%s.pdf} \\ %s %.2f}' % (metric[-1], metric[0], float(summary[metric[-1]]))),
    if (index + 1) % 5 == 0:
        print r' \\'
        print
    else:
        print r' &'
print '\end{tabular}}'
