#include "schnyder.h"
#include <stack>


std::vector<int> matchingFromDyckPath(std::vector<int> &path) {
	std::stack<int> stack;
	std::vector<int> matching;
	matching.reserve(path.size());
	for (int i = 0, endi = path.size(); i < endi; ++i) {
		if (path[i] == 1) {
			stack.push(i);
			matching.push_back(i);
		} else {
			matching.push_back(stack.top());
			matching[matching.back()] = i;
			stack.pop();
		}
	}
	return matching;
}

void addFirstSchnyderTree(std::vector<walkSteps> const &walk, Map<EdgeData> &map) {
	EdgeHandle curEdge = map.getRoot();
	int size = walk.size();
	for (int i = 0; i < size; ++i) {
		switch (walk[i]) {
			case RIGHT:
			case DOWN:
				// the equivalent of an up-step in Dyck path
				curEdge = map.insertEdge(curEdge)->getNext();
				break;
			case UP:
			case LEFT:
				// the equivalent of a down-step in Dyck path
				curEdge = curEdge->getNext();
				break;
		}
	}
}

std::vector<EdgeHandle> addSecondSchnyderTree(std::vector<walkSteps> const &walk, Map<EdgeData> &map) {
	// start with first edge of existing tree
	EdgeHandle curEdge = map.getRoot()->getNext(3);
	int size = walk.size();

	std::queue<int> numheads;
	numheads.push(0);
	for (int i = 0; i < size; ++i) {
		if (walk[i] == RIGHT || walk[i] == UP) {
			numheads.push(0);
		} else {
			++numheads.back();
		}
	}

	std::stack<EdgeHandle> tails;
	std::vector<EdgeHandle> greencorners;
	for (int i = 1; i <= size + 1; ++i) {
		curEdge = curEdge->getNext();

		if (i == size + 1 || walk[i - 1] == RIGHT || walk[i - 1] == DOWN) {
			// curEdge corresponds to first corner of a vertex
			int heads = numheads.front();
			numheads.pop();
			//assert(heads <= static_cast<int>(tails.size()));
			while (heads > 0) {
				map.insertEdge(tails.top(), curEdge);
				tails.pop();
				heads--;
			}
			if (i < size) {
				greencorners.push_back(curEdge->getPrevious());
			}
		}

		if (i < size && (walk[i] == UP || walk[i] == LEFT)) {
			// equiv of Dyck down step
			// curEdge corresponds to last corner of a vertex
			tails.push(curEdge);
		}
	}
	//assert(tails.empty());
	//assert(numheads.empty());
	return greencorners;
}

void walkToBipolarMap(std::vector<walkSteps> const &walk, Map<EdgeData> &map) {
	map.clearMap();
	map.newDoubleEdge();
	map.setRoot(map.getEdge(0));
	EdgeHandle curEdge = map.getRoot()->getNext();
	int size = walk.size();
	for (int i = 0; i < size - 1; ++i) {
		switch (walk[i]) {
			case UP:
				curEdge = map.insertEdge(curEdge->getNext())->getAdjacent();
				break;
			case LEFT:
				curEdge = map.insertEdge(curEdge, curEdge->getNext(2));
				break;
			case RIGHT:
				curEdge = map.insertEdge(curEdge->getPrevious(2), curEdge);
				break;
			case DOWN:
				break;
		}
	}
}

void walkToMap(std::vector<walkSteps> const &walk, Map<EdgeData> &map) {
	map.clearMap();
	map.newDoubleEdge();
	map.setRoot(map.getEdge(0));
	EdgeHandle curEdge = map.getRoot()->getNext();
	int size = walk.size();
	for (int i = 0; i < size - 1; ++i) {
		switch (walk[i]) {
			case UP:
				curEdge = map.insertEdge(curEdge->getNext())->getAdjacent();
				break;
			case DOWN:
				curEdge = map.insertEdge(curEdge->getNext(), curEdge->getPrevious(2))->getAdjacent();
				break;
			case RIGHT:
				curEdge = map.insertEdge(curEdge);
				break;
			case LEFT:
				curEdge = map.insertEdge(curEdge, curEdge->getNext(3));
				break;
		}
	}
}
