#include "liouvillefpp.h"
#include <queue>


struct Node {
	double distance;
	int x, y;
	bool operator <(const Node &node) const { return distance > node.distance; }
};

double shortestpath(std::vector<double> const &time, int width, bool point) {
	int minusOne = width - 1;
	thread_local std::vector<bool> visited;
	visited.assign(width*width, false);

	thread_local std::priority_queue<Node> pqueue;
	if (point) {
		pqueue.push({-.5*time[0*width + width/2], 0, width/2});
		visited[0*width + width/2] = true;
	} else {
		for (int y = 0; y < width; ++y) {
			pqueue.push({-.5*time[0*width + y], 0, y});
			visited[0*width + y] = true;
		}
	}

	while (!pqueue.empty()) {
		auto node = pqueue.top();
		auto x = node.x, y = node.y;
		pqueue.pop();

		auto curTime = time[x*width + y];

		if (x == width - 1 && (!point || y == width/2)) {
			return node.distance + .5*curTime;
		}

		auto explore = [&](int x, int y) {
			if (!visited[x*width + y]) {
				visited[x*width + y] = true;
				pqueue.push({node.distance + curTime, x, y});
			}
		};
		if( x != minusOne ) 
			explore(x + 1, y);
		if( x != 0 )
			explore(x - 1, y);
		explore(x, y == minusOne? 0 : y + 1);
		explore(x, y == 0? minusOne : y - 1);
	}

	return INFINITY;
}

void twopointfunction(std::vector<double> const &time, int width, Histogram &histogram, int startx, int starty) {
	int minusOne = width - 1;
	thread_local std::vector<bool> visited;
	visited.assign(width*width, false);

	thread_local std::priority_queue<Node> pqueue;
	pqueue.push({-.5*time[startx*width + starty], startx, starty});
	visited[startx*width + starty] = true;

	while (!pqueue.empty()) {
		auto node = pqueue.top();
		auto x = node.x, y = node.y;
		pqueue.pop();

		auto curTime = time[x*width + y];

		int bin = static_cast<int>(node.distance + .5*curTime);
		if (bin >= 0 && (unsigned)bin < histogram.size()) {
			++histogram[bin];
		}

		auto explore = [&](int x, int y) {
			if (!visited[x*width + y]) {
				visited[x*width + y] = true;
				pqueue.push({node.distance + curTime, x, y});
			}
		};
		explore(x == minusOne? 0 : x + 1, y);
		explore(x == 0? minusOne : x - 1, y);
		explore(x, y == minusOne? 0 : y + 1);
		explore(x, y == 0? minusOne : y - 1);
	}
}

std::vector<uint8_t> twopointfunctionpaths(std::vector<double> const &time, int width, int startx, int starty) {
	std::vector<uint8_t> paths(width*width);

	int minusOne = width - 1;
	thread_local std::vector<bool> visited;
	visited.assign(width*width, false);

	thread_local std::priority_queue<Node> pqueue;
	pqueue.push({-.5*time[startx*width + starty], startx, starty});
	visited[startx*width + starty] = true;
	paths[startx*width + starty] = 5;

	while (!pqueue.empty()) {
		auto node = pqueue.top();
		auto x = node.x, y = node.y;
		pqueue.pop();

		auto curTime = time[x*width + y];

		auto explore = [&](int x, int y, int returnDir) {
			if (!visited[x*width + y]) {
				visited[x*width + y] = true;
				paths[x*width + y] = returnDir;
				pqueue.push({node.distance + curTime, x, y});
			}
		};
		explore(x == minusOne? 0 : x + 1, y, 4);
		explore(x == 0? minusOne : x - 1, y, 6);
		explore(x, y == minusOne? 0 : y + 1, 1);
		explore(x, y == 0? minusOne : y - 1, 9);
	}

	return paths;
}
