
#define null false
#define NewRequest true
#define NewLocation true
#define NewMA true
#define STARTING 0
#define RUNNING 1
#define STOPPED 2

bool locationrequest = false;
bool lureceive = false;
bool lusend = false;
bool onboardreceive = false;
bool rbcreceive = false;
bool rbcsend = false;
bool receivema = false;
short counter =0;
short maxcycles =3;
short STATUS = RUNNING;



/*  INITIALIZATIONS */
init {

  do

//---------------------------------------------
//              Generation Request           --
//---------------------------------------------

   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        receivema == null
       ) ->  
      locationrequest = NewRequest;
      counter = counter+1;
   };  


//---------------------------------------------
//               Send Request                --
//---------------------------------------------

// SendRequest_Failure =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        locationrequest == NewRequest &&
        receivema == null
       ) ->  
       locationrequest = null;
   };  


// SendRequest_LUreceive =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        locationrequest == NewRequest &&
        receivema == null
       ) ->  
       locationrequest = null;
       lureceive = NewRequest;
   };  

 
//---------------------------------------------
//           Calculate Location (CL)         --
//---------------------------------------------

// Calculate_Location_Failure =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        lureceive == NewRequest &&
        receivema == null
       ) ->  
        lureceive = null;
       ;
   };  

// Calculate_Location =
  :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        lureceive == NewRequest &&
        receivema == null
       ) ->  
       lureceive = null; 
       lusend = NewLocation;
   };  
   

//-----------------------------------------------
//--           Sending Location (SL)         --
//-----------------------------------------------

// Send_Location =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        lusend == NewLocation &&
        receivema == null
       ) ->  
        lusend = null;
       ;
   };  
   
   
// SendLocation_OnBoardReceive
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        lusend == NewLocation &&
        receivema == null
       ) ->  
        lusend = null;   
        onboardreceive = NewLocation ;
       ;
   };  
   
   
//-----------------------------------------------
//--        Send Location to RBC (SLRBC)       --
//-----------------------------------------------
 

// Send_Location_Failure =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        onboardreceive == NewLocation &&
        receivema == null
       ) ->  
        onboardreceive = null;
   };  
   
   
// SendLocation_RBCreceive = 
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        onboardreceive == NewLocation &&
        receivema == null
       ) ->  
        onboardreceive = null; 
        rbcreceive = NewLocation;
   };  
   
 
//-----------------------------------------------
//--            Calculation of MA (CMA)        --
//-----------------------------------------------


// Calculate_MA_Failure =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        rbcreceive == NewLocation &&
        receivema == null
       ) ->  
       rbcreceive = null;
   };  
   
   
// Calculate_MA =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        rbcreceive == NewLocation &&
        receivema == null
       ) ->  
        rbcreceive = null; 
        rbcsend = NewMA;
   };  
   
   
//-----------------------------------------------
//--            Sending of MA (SMA)        --
//-----------------------------------------------

// Send_MA_Failure =   
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        rbcsend == NewMA &&
        receivema == null
       ) ->  
       rbcsend = null;
   };  
   
// SendMA_ReceiveMA =
   :: atomic {
       (STATUS == RUNNING  &&
        counter <= maxcycles &&
        rbcsend == NewMA &&
        receivema == null
       ) ->  
       rbcsend = null;  
       receivema = NewMA;
   };  
          
//-----------------------------------------------
//--                Receive MA (RMA)           --
//-----------------------------------------------

 //  HandleMA = 
   :: atomic {
       (STATUS == RUNNING  &&
        receivema == NewMA
       ) ->  
       receivema = null;
       counter = 0;
   };  

// Stop =
   :: atomic {
       (STATUS == RUNNING  &&
        counter > maxcycles &&
        receivema == null
       ) ->  
       STATUS = STOPPED;
   };  
  od;
}


///////////////////    PROPERTIES    ///////////////

// ACTL:  AG true
//
// ltl p0 {always true}
//        446 states, stored

// ACTL:  EF {Stop} true
//
// ltl p1 {always (STATUS != STOPPED)}
//     p1 is FALSE, trace shows path to the STOPPED status


// ACTL:  AF {Stop or HandleMA} true
//
// ltl p2 {eventually ((STATUS == STOPPED) || (receivema == NewMA))}
//     p2 is TRUE, (0 errors)


// ACTL:  AF {Stop or HandleMA} true
//
// ltl p3 {always eventually ((STATUS == STOPPED) || (receivema == NewMA))}
//     p3 is TRUE, (0 errors)


/*   verfication process
//  spin -a SPIN_M*
//  gcc -o pan pan.c
//  pan -a
*/
