pragma solidity ^0.5.2;

contract Crowdfunding {
    address owner;
    uint256 deadline;
    uint256 goal;
    mapping(address => uint256) public pledgeOf;

    constructor(uint256 numberOfDays, uint256 _goal, address[] memory _pledgers) public {
        owner = msg.sender;
        deadline = now + (numberOfDays * 1 days);
        goal = _goal;

        for (uint i = 0; i < _pledgers.length; i++) {
            address _pledger = _pledgers[i];
            pledgeOf[_pledger] = 1000;
        }
    }

    function pledge(uint256 amount) public payable {
        require(now < deadline);                // in the fundraising period
        require(msg.value == amount);

        pledgeOf[msg.sender] += amount;
    }

    function claimFunds() public {
        require(address(this).balance >= goal); // funding goal met
        require(now >= deadline);               // in the withdrawal period
        require(msg.sender == owner);

        msg.sender.transfer(address(this).balance);
    }

    function getRefund() public {
        require(address(this).balance < goal);  // funding goal not met
        require(now >= deadline);               // in the withdrawal period

        uint256 amount = pledgeOf[msg.sender];
        pledgeOf[msg.sender] = 0;
        msg.sender.transfer(amount);
    }
}