+++
date = "2019-08-13T11:00:13+01:00"
title = "6.2.1"
author = "Lars Bilke"
release_date = "2019-08-13"

[downloads]
win = [
    "Windows-10.0.14393-x64-de-utils.zip",
    "Windows-10.0.14393-x64-python-3.7.2-de-utils.zip"
]
linux = [
    "Linux-FIXME-x64-utils.tar.gz",
    "Linux-FIXME-x64-de-utils.tar.gz",
    "Linux-FIXME-x64-python-3.6.3-utils.tar.gz",
    "Linux-FIXME-x64-python-3.6.3-de-utils.tar.gz"
]
osx = [ "OSX-10.14-x64-de-utils.tar.gz" ]
container = [
    "serial.sif",
    "openmpi-2.1.6.sif",
    "openmpi-3.1.4.sif",
    "openmpi-4.0.1.sif"
]
note = """
**Note:** When using Python bindings make sure to have Python installed on your system:

- Windows: [Python 3.7.2](https://www.python.org/ftp/python/3.7.2/python-3.7.2-amd64-webinstall.exe)
- Linux: Python 3.6.8
"""
+++

## Features

### New processes

- A thermo-hydro-mechanical (THM) process, monolithic implementation for Newton non-linear solver. [#2446](https://github.com/ufz/ogs/pull/2446)

### Other process' changes
- Non-equilibrium initial state in the small deformation, HM, and TM processes. [#2501](https://github.com/ufz/ogs/pull/2501), [#2561](https://github.com/ufz/ogs/pull/2561), and [#2544](https://github.com/ufz/ogs/pull/2544)
- A reactive transport process, integrated IPhreeqc Module 3.5.0 for reactive transport modeling. [#2494](https://github.com/ufz/ogs/pull/2494), [#2512](https://github.com/ufz/ogs/pull/2512)
- Fix velocity output in HM. [#2507](https://github.com/ufz/ogs/pull/2507)
- Store process' names in the Process class instead of an outside map. [#2534](https://github.com/ufz/ogs/pull/2534)
- Generalize permeability models for the fracture flow in LIE/HM:
  - CubicLaw (just generalization). [#2542](https://github.com/ufz/ogs/pull/2542)
  - ConstantPermeability. [#2543](https://github.com/ufz/ogs/pull/2543)
- Add simple mass lumping to the RichardsMechanics. [#2590](https://github.com/ufz/ogs/pull/2590)

#### Numerics

#### Parameter
- new TimeDependentHeterogeneousParameter. [#2588](https://github.com/ufz/ogs/pull/2588)
  Feature can be used for time dependent heterogeneous boundary condition or source term specification.

#### Boundary condition

#### Source term

#### Input and output
- HT process: Use MaterialPropertyLibrary for solid phase properties, too. This makes it necessary to changed the project files. [#2487](https://github.com/ufz/ogs/pull/2487)
- Reactive transport process: Output time-series amounts of kinetic reactants and equilibrium phases defined under the subtree of chemical system. [#2564](https://github.com/ufz/ogs/pull/2564)

### Material models

- Orthotropic elasticity model. [#2428](https://github.com/ufz/ogs/pull/2428)
- Dupuit permeability relation. [#2330](https://github.com/ufz/ogs/pull/2330)

### File I/O

* Gocad TSurface reader has been added [#2547](https://github.com/ufz/ogs/pull/2547)
* Gocad PLine reader has been added [#2586](https://github.com/ufz/ogs/pull/2586)

### Testing and documentation

### New tools

* GocadTSurfaceReader command line utility [#2547](https://github.com/ufz/ogs/pull/2547)/[#2586](https://github.com/ufz/ogs/pull/2586)

### New tools and CLI usage

* Add switch multiple-nodes-allowed to tool constructMeshesFromGeometry, [#2459](https://github.com/ufz/ogs/pull/2459)
* Add option to vtkdiff tool to compare meshes using absolute tolerances and connectivity, [#2485](https://github.com/ufz/ogs/pull/2485)
* Scalar arrays are copied when using the ExtractSurface-tool, [#2492](https://github.com/ufz/ogs/pull/2492)

### Data Explorer

* Mesh to shape export is now writing all cell-based scalar arrays to the DBF-file, [#2436](https://github.com/ufz/ogs/pull/2436)
* Added support of world files to georeference arbitrary raster files, [#2460](https://github.com/ufz/ogs/pull/2460)
* Scalar arrays are copied when extracting mesh surfaces, [#2492](https://github.com/ufz/ogs/pull/2492)
* Gocad TSurfaces can be imported into Data Explorer [#2547](https://github.com/ufz/ogs/pull/2547)
* Gocad PLines can be imported into Data Explorer [#2586](https://github.com/ufz/ogs/pull/2586)

### Other notable code changes

 * Conversion to linear mesh is now independent of node numbering. [#2519](https://github.com/ufz/ogs/pull/2519)

## Development workflows

- Added git hooks via [pre-commit](https://pre-commit.com/). See [docs/devguide/getting-started/get-the-source-code/](https://www.opengeosys.org/docs/devguide/getting-started/get-the-source-code/) for installation instructions, [#2599](https://github.com/ufz/ogs/pull/2599)

## Infrastructure

### Jenkins

- Added web link checker, [#2572](https://github.com/ufz/ogs/pull/2572)
- Reordered Jenkins pipeline for better concurrency, [#2560](https://github.com/ufz/ogs/pull/2560)
- Updated Docker base images to Ubuntu 18.04, [#2493](https://github.com/ufz/ogs/pull/2493)
- Migrated from envinf1 to frontend2, [#2440](https://github.com/ufz/ogs/pull/2440)
- Conan: Use lower-case package names for qt, vtk and shapelib, [#2450](https://github.com/ufz/ogs/pull/2450), [#2573](https://github.com/ufz/ogs/pull/2573)

### CMake options changes

- Bumbed miniumum CMake version to 3.12, [#2597](https://github.com/ufz/ogs/pull/2597)
- Added option `OGS_CONAN_BUILD_TYPE` to overwrite Conan build type, [#2577](https://github.com/ufz/ogs/pull/2577)

### Web / Docs

- Added embedded screen recordings with https://asciinema.org, [#2510](https://github.com/ufz/ogs/pull/2510)

### Version info

- CMake minimum 3.12
- VTK minimum 8.2
