+++
date = "2019-03-13T11:00:13+01:00"
title = "6.2.0"
author = "Lars Bilke"
release_date = "2019-03-20"

[downloads]
win = [
    "Windows-10.0.14393-x64-de-utils.zip",
    "Windows-10.0.14393-x64-python-3.7.2-de-utils.zip"
]
linux = [
    "Linux-3.10.0-957.1.3.el7.x86_64-x64-utils.tar.gz",
    "Linux-4.20.8-arch1-1-ARCH-x64-de-utils.tar.gz",
    "Linux-3.10.0-957.1.3.el7.x86_64-x64-python-3.6.3-utils.tar.gz",
    "Linux-4.20.8-arch1-1-ARCH-x64-python-3.6.3-de-utils.tar.gz"
]
osx = [ "OSX-10.14-x64-de-utils.tar.gz" ]
container = [
    "serial.sif",
    "openmpi-2.1.2.sif",
    "openmpi-3.1.2.sif"
]
note = """
**Note:** When using Python bindings make sure to have Python installed on your system:

- Windows: [Python 3.7.2](https://www.python.org/ftp/python/3.7.2/python-3.7.2-amd64-webinstall.exe)
- Linux: Python 3.6.3
"""
+++

The following notable changes and new features were implemented between OpenGeoSys 6.1.0 and 6.2.0:

## Features

### New processes

- HeatTransportBHE process supporting 1U, CXA, and CXC BHE types. [#2221](https://github.com/ufz/ogs/pull/2221), [#2332](https://github.com/ufz/ogs/pull/2332),
  [#2271](https://github.com/ufz/ogs/pull/2271), [#2275](https://github.com/ufz/ogs/pull/2275)
- Staggered implementation of a thermo-mechanical with phasefield process. [#2102](https://github.com/ufz/ogs/pull/2102)
- Richards mechanics process. [#2189](https://github.com/ufz/ogs/pull/2189)
- Small deformation process with non-local integration of damage. [#2294](https://github.com/ufz/ogs/pull/2294)
- Staggered implementation of phasefield process. [#2052](https://github.com/ufz/ogs/pull/2052)
- ComponentTransport process in revised formulation. [#2200](https://github.com/ufz/ogs/pull/2200)
- Multi-component transport process. [#2304](https://github.com/ufz/ogs/pull/2304)

### Other process' changes

- A Jacobian tester: a process's Jacobian assembly can be compared to a
  numerical Jacobian (mostly for development. [#2238](https://github.com/ufz/ogs/pull/2238)
- Add `setInitialConditions()` call to processes and local assemblers. [#2334](https://github.com/ufz/ogs/pull/2334)
- Several bug fixes for LIE/HM process including "fracture into matrix
  leak-off", Darcy velocity output in the fracture. [#2129](https://github.com/ufz/ogs/pull/2129)
- Support for intersecting fractures (x-crossing and t-junction) in LIE/SD
  process. [#2235](https://github.com/ufz/ogs/pull/2235), [#2293](https://github.com/ufz/ogs/pull/2293)
- Fixed the calculation of the Darcy velocity in staggered TH. [#2127](https://github.com/ufz/ogs/pull/2127)

#### Numerics

- Staggered scheme for coupled processes with different orders of elements.
  [#2016](https://github.com/ufz/ogs/pull/2016)
- Subdomain deactivation within time intervals. [#2297](https://github.com/ufz/ogs/pull/2297)
- Add a driver for an iteration based time stepping algorithm. [#2318](https://github.com/ufz/ogs/pull/2318)

#### Boundary condition

- Implementation of Python boundary conditions. [#2170](https://github.com/ufz/ogs/pull/2170)
- Implementation of constraint boundary conditions. [#2145](https://github.com/ufz/ogs/pull/2145)
- Dirichlet boundary condition within a time interval. [#2272](https://github.com/ufz/ogs/pull/2272)
- BoundaryElementSearch: Return bulk element id and bulk element face id. [#2125](https://github.com/ufz/ogs/pull/2125)
- Removed Neumann boundary condition for displacement jumps in LIE processes.
  [#2153](https://github.com/ufz/ogs/pull/2153)

#### Source term

- Use parameter for source terms. [#2061](https://github.com/ufz/ogs/pull/2061)
- Volumetric source terms implementation. [#2220](https://github.com/ufz/ogs/pull/2220), [#2234](https://github.com/ufz/ogs/pull/2234), [#2241](https://github.com/ufz/ogs/pull/2241), [#2261](https://github.com/ufz/ogs/pull/2261)

#### Input and output

- Writing and reading of integration point data. Implemented sigma and epsilon
  output for some processes. [#2071](https://github.com/ufz/ogs/pull/2071), [#2203](https://github.com/ufz/ogs/pull/2203), [#2324](https://github.com/ufz/ogs/pull/2324)
- Add input of vtu-meshes for boundary conditions additionally to the gml input.
  This is later used by the heterogeneous parameters and source terms. [#2140](https://github.com/ufz/ogs/pull/2140),
  [#2141](https://github.com/ufz/ogs/pull/2141), [#2156](https://github.com/ufz/ogs/pull/2156)
- Parameters may now be explicitly defined on arbitrary subdomains. This merges
  the Heterogeneous Dirichlet and Neumann boundary conditions with their,
  previously only homogeneous, counterparts. [#2376](https://github.com/ufz/ogs/pull/2376)
- Parameters now support space-dependent function input via exprtk library.
  [#2325](https://github.com/ufz/ogs/pull/2325), [#2339](https://github.com/ufz/ogs/pull/2339)
- Output of primary variables on arbitrary subdomains. [#2372](https://github.com/ufz/ogs/pull/2372), [#2299](https://github.com/ufz/ogs/pull/2299)
- Output is possible at specific times for adaptive time stepping and
  evolutionaryPIDController. [#2079](https://github.com/ufz/ogs/pull/2079)
- Calculate and output specific flux. [#2411](https://github.com/ufz/ogs/pull/2411)
- Enable surface flux calculation for component transport process. [#2168](https://github.com/ufz/ogs/pull/2168)
- Interpolated pressure (on higher order elements' nodes) output for
  Richards-mechanics and hydro-mechanics processes. [#2228](https://github.com/ufz/ogs/pull/2228)
- Improve output of nodal aperture and aperture vector in LIE/HM. [#2050](https://github.com/ufz/ogs/pull/2050)
- Add output of nodal forces and hydraulic flow in mechanics and coupled
  mechanics processes, SD, HM, LIE/SD, LIE/HM. [#2118](https://github.com/ufz/ogs/pull/2118)
- Enable surface flux calculation for HT process. [#2132](https://github.com/ufz/ogs/pull/2132)
- Fixed pvd output. [#2036](https://github.com/ufz/ogs/pull/2036)

### Material models

- BGRa creep model. [#2167](https://github.com/ufz/ogs/pull/2167)
- New cohesive zone mode I fracture model for LIE processes. [#2142](https://github.com/ufz/ogs/pull/2142), [#2157](https://github.com/ufz/ogs/pull/2157)
- Add MFront/TFEL solid constitutive relation support via.
  MFrontGenericInterfaceSupport library. CMake option `OGS_USE_MFRONT`. [#2259](https://github.com/ufz/ogs/pull/2259)
- Infrastructure for multi-phase, multi-component material properties library.
  [#2303](https://github.com/ufz/ogs/pull/2303),
  [#2415](https://github.com/ufz/ogs/pull/2415)
- Anisotropic tensors may now be given in given local coordinate system. [#2370](https://github.com/ufz/ogs/pull/2370)
- Non-constant density model implementation in HC process. [#2200](https://github.com/ufz/ogs/pull/2200)
- Add second derivatives of permeability functions in Richards flow. [#2188](https://github.com/ufz/ogs/pull/2188)
- Different solid material models can now be defined on different materialIDs.
  [#2216](https://github.com/ufz/ogs/pull/2216), [#2262](https://github.com/ufz/ogs/pull/2262), [#2270](https://github.com/ufz/ogs/pull/2270)
- Move solid constitutive relation creation in single place. [#2160](https://github.com/ufz/ogs/pull/2160)

### Testing and documentation

- Migrated Appveyor tests to [Azure
  Pipelines](https://dev.azure.com/ogsci/ogs/_build). [#2342](https://github.com/ufz/ogs/pull/2342)
- Added cppcheck, clang-tidy and include-what-you-use. [#2078](https://github.com/ufz/ogs/pull/2078), [#2328](https://github.com/ufz/ogs/pull/2328), [#2377](https://github.com/ufz/ogs/pull/2377)
- Added check for header standalone compilation, can be enabled with
  `OGS_CHECK_HEADER_COMPILATION=ON`. [#2043](https://github.com/ufz/ogs/pull/2043)
- Jenkins shows nice summaries of compiler warnings. [#2206](https://github.com/ufz/ogs/pull/2206)
- Large tests are fixed and run on Jenkins upon master merge. [#2056](https://github.com/ufz/ogs/pull/2056), [#2155](https://github.com/ufz/ogs/pull/2155)
- Re-enabled code coverage reports (for the testrunner only) with
  [Codecov](http://codecov.io/gh/ufz/ogs). [#2333](https://github.com/ufz/ogs/pull/2333), [#2336](https://github.com/ufz/ogs/pull/2336)
- Commits containing `[ci skip]` in the commit message do not trigger a Jenkins
  build.
- Add `vtkdiff` test configuration to project files, s.t. the vtkdiff tests are
  performed after successful run comparing output to reference files. This
  possibility is also reflected in a new CMake function `OgsTest` as an
  alternative to the `AddTest`. [#2255](https://github.com/ufz/ogs/pull/2255), [#2257](https://github.com/ufz/ogs/pull/2257)

### New tools

- `TecPlotTools`: splitting files containing multiple zones into seperate
  TecPlot files. [#2114](https://github.com/ufz/ogs/pull/2114)
- `TecPlot-Reader`: converting TecPlot rasters into OGS meshes (one file per
  zone, containing all variables as scalar arrays). [#2114](https://github.com/ufz/ogs/pull/2114)
- [`constructMeshesFromGeometry`](https://www.opengeosys.org/docs/tools/meshing-submeshes/constructmeshesfromgeometry/):
  Construction of boundary meshes from bulk mesh and gml files. [#2144](https://github.com/ufz/ogs/pull/2144)
- [`identifySubdomains`](https://www.opengeosys.org/docs/tools/meshing-submeshes/identifysubdomains/):
  Identification of boundary meshes (or any subdomains in general) in the bulk
  mesh. Performs geometrical tests and creates and verifies necessary
  `bulk_node_ids` and `bulk_element_ids` maps. [#2227](https://github.com/ufz/ogs/pull/2227), [#2252](https://github.com/ufz/ogs/pull/2252)
- `Mesh2Raster`: converts 2D OGS meshes into raster files of arbitrary pixel
  size, where node elevation is represented by pixel value. [#2367](https://github.com/ufz/ogs/pull/2367)
- `GocadSGridReader` tool reading the Gocad/SKUA stratigraphic grid format and
  writing the data in the vtu format. [#2316](https://github.com/ufz/ogs/pull/2316)

### New tools and CLI usage

- `ogs --help` shows the given CMake options. [#2210](https://github.com/ufz/ogs/pull/2210)
- Unify command line version info output. [#2194](https://github.com/ufz/ogs/pull/2194)
- Rewrite `partmesh` tool and add partitioning of boundary meshes (or subdomains
  in general) according to the partition of the bulk mesh. [#2159](https://github.com/ufz/ogs/pull/2159), [#2178](https://github.com/ufz/ogs/pull/2178), [#2195](https://github.com/ufz/ogs/pull/2195)
- Add new features to `ExtractSurface` tool. [#2387](https://github.com/ufz/ogs/pull/2387), [#2401](https://github.com/ufz/ogs/pull/2401)
- updated utility `moveMeshNodes`: algorithm for mesh on mesh mapping now
  calculates exact node elevation instead of using interpolation. [#2390](https://github.com/ufz/ogs/pull/2390)

### Data Explorer

- Listing of source terms and boundary conditions in Data Explorer DataView (no
  visualisation yet). [#2110](https://github.com/ufz/ogs/pull/2110)
- Mesh element removal can now remove elements based on value ranges of
  arbitrary scalar arrays (currently only int- and double arrays are supported).
  [#2115](https://github.com/ufz/ogs/pull/2115)
- added custom VTK filter to represent raster data as point clouds. [#2121](https://github.com/ufz/ogs/pull/2121)
- geometrical points can now be converted into station points. [#2369](https://github.com/ufz/ogs/pull/2369)
- fixed issue with geometrical surfaces not being loaded correctly. [#2388](https://github.com/ufz/ogs/pull/2388)
- Replace deprecated QVTKWidget with QVTKOpenGLWidget [#2432](https://github.com/ufz/ogs/pull/2432)

### Other notable code changes

- C++17 standard is enabled and is allowed in the production code (given the
  compiler support). [#2298](https://github.com/ufz/ogs/pull/2298)
- Separate monolithic ProcessLib into individual processes. Now it is possible
  to build ogs with selected processes only. This also improves linking times.
  [#2017](https://github.com/ufz/ogs/pull/2017)
- Parameters are extracted in own library. [#2413](https://github.com/ufz/ogs/pull/2413)
- Port secondary variable extrapolation and output for PETSc builds. [#2082](https://github.com/ufz/ogs/pull/2082)
- Extend Kelvin mapping functions and move implementation to MathLib. [#2060](https://github.com/ufz/ogs/pull/2060),
  [#2075](https://github.com/ufz/ogs/pull/2075), [#2044](https://github.com/ufz/ogs/pull/2044)
- Collect generic algorithms in single header file. [#2161](https://github.com/ufz/ogs/pull/2161)
- Remove unused MeshSubsets class. [#2135](https://github.com/ufz/ogs/pull/2135)
- Removed writing of xsd header in XML files, [#2198](https://github.com/ufz/ogs/pull/2198)

## Infrastructure

- Migrated LFS storage from GitLab to [Artifactory](https://ogs.jfrog.io/ogs).
  [#2359](https://github.com/ufz/ogs/pull/2359)
- Optimized ctest runtime by starting long-running benchmarks first. [#2310](https://github.com/ufz/ogs/pull/2310)
- Proper RPATH handling for shared library installations. [#2208](https://github.com/ufz/ogs/pull/2208)
- [Package OGS inside
  container](https://www.opengeosys.org/docs/userguide/basics/container/) with
  [Singularity](https://www.sylabs.io/singularity/); [more
  docs](https://www.opengeosys.org/docs/devguide/advanced/singularity/). [#2193](https://github.com/ufz/ogs/pull/2193),
  [#2356](https://github.com/ufz/ogs/pull/2356)
- Migrated opengeosys.org to a static site generator ([Hugo](https://gohugo.io))
  unifying documentation and general OGS info. [#2088](https://github.com/ufz/ogs/pull/2088), [#2095](https://github.com/ufz/ogs/pull/2095), [#2123](https://github.com/ufz/ogs/pull/2123)
- Speed-up CMake run time. [#2072](https://github.com/ufz/ogs/pull/2072), [#2392](https://github.com/ufz/ogs/pull/2392)

### CMake options changes

- `OGS_USE_PYTHON` enables Python BCs. [#2170](https://github.com/ufz/ogs/pull/2170)
- `OGS_BUILD_TESTS` was renamed to `BUILD_TESTING`. [#2350](https://github.com/ufz/ogs/pull/2350)
- Added `OGS_USE_CVODE`. [#2344](https://github.com/ufz/ogs/pull/2344)
- Added `OGS_BUILD_PROCESSES` for `;`-separated list of processes to build.
  [#2233](https://github.com/ufz/ogs/pull/2233)
- `OGS_USE_CONAN=ON` is now the default when `conan` was found. [#2207](https://github.com/ufz/ogs/pull/2207)

### Version info

- CMake minimum version 3.10
- Visual Studio minimum (and tested) version 2017
- GCC minimum version 6.2 (tested: 6.4)
- Clang minimum version 3.5 (tested: 7.0)
- Boost minimum version 1.66.0
- VTK minimum version 8.1. [#2158](https://github.com/ufz/ogs/pull/2158)
- Qt tested version 5.11.2
- Python tested version 3.7.2
