/**
 * \copyright
 * Copyright (c) 2012-2019, OpenGeoSys Community (http://www.opengeosys.org)
 *            Distributed under a Modified BSD License.
 *              See accompanying file LICENSE.txt or
 *              http://www.opengeosys.org/project/license
 */

#pragma once

#include <vector>

namespace MeshLib
{
class Element;
class Mesh;
class Node;
}  // namespace MeshLib

namespace ProcessLib
{
namespace LIE
{
/**
 * get data about fracture and matrix elements/nodes from a mesh
 *
 * @param mesh  A mesh which includes fracture elements, i.e. lower-dimensional
 * elements. It is assumed that elements forming a fracture have a distinct
 * material ID.
 * @param vec_matrix_elements  a vector of matrix elements
 * @param vec_fracture_mat_IDs  fracture material IDs found in the mesh
 * @param vec_fracture_elements  a vector of fracture elements (grouped by
 * fracture IDs)
 * @param vec_fracture_matrix_elements  a vector of fracture elements and matrix
 * elements connecting to the fracture (grouped by fracture IDs)
 * @param vec_fracture_nodes  a vector of fracture element nodes (grouped by
 * fracture IDs)
 * @param vec_branch_nodeID_matIDs  a vector of branch node IDs found in the
 * mesh (and corresponding fracture material IDs)
 * @param vec_junction_nodeID_matIDs  a vector of junction node IDs found in the
 * mesh (and corresponding fracture material IDs)
 */
void getFractureMatrixDataInMesh(
    MeshLib::Mesh const& mesh,
    std::vector<MeshLib::Element*>& vec_matrix_elements,
    std::vector<int>& vec_fracture_mat_IDs,
    std::vector<std::vector<MeshLib::Element*>>& vec_fracture_elements,
    std::vector<std::vector<MeshLib::Element*>>& vec_fracture_matrix_elements,
    std::vector<std::vector<MeshLib::Node*>>& vec_fracture_nodes,
    std::vector<std::pair<std::size_t, std::vector<int>>>&
        vec_branch_nodeID_matIDs,
    std::vector<std::pair<std::size_t, std::vector<int>>>&
        vec_junction_nodeID_matIDs);

}  // namespace LIE
}  // namespace ProcessLib
