/**
 * \copyright
 * Copyright (c) 2012-2019, OpenGeoSys Community (http://www.opengeosys.org)
 *            Distributed under a Modified BSD License.
 *              See accompanying file LICENSE.txt or
 *              http://www.opengeosys.org/project/license
 *
 */

#pragma once

#include <vector>

#include <Eigen/Eigen>

#include "NumLib/Fem/CoordinatesMapping/ShapeMatrices.h"

namespace ProcessLib
{
namespace HeatTransportBHE
{
/// Used for extrapolation of the integration point values. It is ordered
/// (and stored) by integration points.
template <typename ShapeMatrixType>
struct SecondaryData
{
    std::vector<ShapeMatrixType, Eigen::aligned_allocator<ShapeMatrixType>> N;
};
}  // namespace HeatTransportBHE
}  // namespace ProcessLib
