/**
 * \copyright
 * Copyright (c) 2012-2019, OpenGeoSys Community (http://www.opengeosys.org)
 *            Distributed under a Modified BSD License.
 *              See accompanying file LICENSE.txt or
 *              http://www.opengeosys.org/project/license
 *
 */

#include <ostream>

#include "Output.h"

namespace ChemistryLib
{
std::ostream& operator<<(std::ostream& os,
                         BasicOutputSetups const& basic_output_setups)
{
    os << "-file " << basic_output_setups.output_file << "\n";
    os << "-high_precision " << std::boolalpha
       << ChemistryLib::BasicOutputSetups::use_high_precision << "\n";
    os << "-simulation " << std::boolalpha
       << ChemistryLib::BasicOutputSetups::display_simulation_id << "\n";
    os << "-state " << std::boolalpha
       << ChemistryLib::BasicOutputSetups::display_state << "\n";
    os << "-distance " << std::boolalpha
       << ChemistryLib::BasicOutputSetups::display_distance << "\n";
    os << "-time " << std::boolalpha
       << ChemistryLib::BasicOutputSetups::display_current_time << "\n";
    os << "-step " << std::boolalpha
       << ChemistryLib::BasicOutputSetups::display_time_step << "\n";

    return os;
}

std::ostream& operator<<(std::ostream& os, Output const& output)
{
    os << output.basic_output_setups;

    auto const component_items =
        output.getOutputItemsByItemType(ItemType::Component);
    os << "-totals";
    for (auto const& component_item : component_items)
    {
        os << " " << component_item.name;
    }
    os << "\n";

    auto const equilibrium_phase_items =
        output.getOutputItemsByItemType(ItemType::EquilibriumPhase);
    if (!equilibrium_phase_items.empty())
    {
        os << "-equilibrium_phases";
        for (auto const& equilibrium_phase_item : equilibrium_phase_items)
        {
            os << " " << equilibrium_phase_item.name;
        }
        os << "\n";
    }

    auto const kinetic_reactant_items =
        output.getOutputItemsByItemType(ItemType::KineticReactant);
    if (!kinetic_reactant_items.empty())
    {
        os << "-kinetic_reactants";
        for (auto const& kinetic_reactant_item : kinetic_reactant_items)
        {
            os << " " << kinetic_reactant_item.name;
        }
        os << "\n";
    }

    return os;
}
}  // namespace ChemistryLib
