/**
 * \copyright
 * Copyright (c) 2012-2019, OpenGeoSys Community (http://www.opengeosys.org)
 *            Distributed under a Modified BSD License.
 *              See accompanying file LICENSE.txt or
 *              http://www.opengeosys.org/project/license
 *
 */

#include <pybind11/embed.h>
#include <logog/include/logog.hpp>

#include "ogs_embedded_python.h"

#include "ProcessLib/BoundaryCondition/Python/PythonBoundaryConditionModule.h"
#include "ProcessLib/SourceTerms/Python/PythonSourceTermModule.h"

PYBIND11_EMBEDDED_MODULE(OpenGeoSys, m)
{
    DBUG("Binding Python module OpenGeoSys.");

    ProcessLib::pythonBindBoundaryCondition(m);
    ProcessLib::SourceTerms::Python::pythonBindSourceTerm(m);
}

#ifndef OGS_BUILD_SHARED_LIBS

// Hackish trick that hopefully ensures that the linker won't strip the symbol
// pointed to by p from the library being built.
template <typename T>
void mark_used(T p)
{
    volatile T vp = p;
    vp = vp;
}

#endif  // OGS_BUILD_SHARED_LIBS

namespace ApplicationsLib
{
pybind11::scoped_interpreter setupEmbeddedPython()
{
#ifndef OGS_BUILD_SHARED_LIBS
    // pybind11_init_impl_OpenGeoSys is the function initializing the embedded
    // OpenGeoSys Python module. The name is generated by pybind11. If it is not
    // obvious that this symbol is actually used, the linker might remove it
    // under certain circumstances.
    mark_used(&pybind11_init_impl_OpenGeoSys);
#endif

    return pybind11::scoped_interpreter{};
}

}  // namespace ApplicationsLib
