function StoreParameter(varargin)
%%  StoreParameter(mws,noOfParameters,parameterName1,parameterValue1[,parameterName2,parameterValue2,...])
% This function stores the parameter values into CST paramter list and all 
% the parameters in the cst file is written into a log a file
% Parameters: mws: COM object
%                    COM object model associated with the cst file
%             noOfParamters: Integer
%                            This specifes the no of paramter values to be
%                            written into cst nad these many sets of
%                            paramter name and value should also be given
%                            as argument of this function
%             paramterName1: string
%                            Parameter name same as in cst parameter list
%             paramterValue1: Integer
%                             New value of the paramter value to be stored
%                             in cst paramter list
%             paramterName2: string, optional
%                            Parameter name same as in cst parameter list.
%             paramterValue2: Integer, optional
%                             New value of the paramter value to be stored
%                             in cst paramter list   
% noOfParamters must be equal to the number paramtervalues to be stored
% into cst. Any number of paramter value can be stored into cst by
% repeating the order as mentioned above.
%
% Returns:  Default all the paramter values in the paramter lsit of cst is
%           stored into a log file generated by openCST function
% Raises:     argumentError: mismatch or inadequate arguments for the
%                            function
%              cstVersionError: this cst version is not installed in your pc
%              fileLocationError: cst file is not found at the specified location
            
%% Checking the arguments
minInputs = 4;   % minimum numbers of input arguments allowed
% maximum numbers of input arguments allowed
maxInputs = Inf;

% checking for minumum number of arguments
narginchk(minInputs,maxInputs);

[~,n] = size(varargin); 

% check the value of second argument == total # arguments or not?
assert( (varargin{2}*2)+2== n,'Please make sure that you define correct number of arguments.');

%% Checking the noOfParamters and parameter name and value set matching
for i = 2 :(varargin{2}*2)+2
    if mod (i,2) == 0
        assert(isinteger(varargin{i})|isfloat(varargin{i}),'Parameter(s) value should be integer or float type(s). ');
    elseif i == 2
        assert(isinteger(varargin{2}),'Parameter value should be integer type. ');
    else
        assert(ischar(varargin{i}),'Parameter(s) name should be character(s) type. ');
    end
end
%% To store the parameter values 
for j = 3 :(varargin{2}*2)+2-1
    if mod (j,2) ~= 0
        invoke(varargin{1},'StoreParameter',varargin{j},varargin{j+1});
        disp(['Paramter ', varargin{j}, ' with value ',num2str(varargin{j+1}),' was stored in cst file succesfully']);
    end
end
% After storing the paramter values the cst model need to be rebuild. Below
% command rebuilds the histroy so that new geometry is build according to
% the new set of paramter values stored in cst
invoke(varargin{1},'rebuild'); 
disp('Geometric model in cst was rebuilt with new parametric values');

%% Writing all the paramter list in cst into a log file
global project_location;
global finalpath;
global fileid;
[~,deepestFolder] = fileparts(project_location);
newSubFolder = sprintf('%s/LogFile_%s', project_location, deepestFolder);
if ~exist(newSubFolder, 'dir')
    mkdir(newSubFolder);
end
fileid = fopen(finalpath, 'a');
fprintf(fileid,'\r\n____________________________________________________________________________________\r\n ');
fprintf(fileid,'\r\t Date & Time : ');
% fprintf(fileid, '%s\r\n', datetime('now','Format','dd-MMM-yyyy HH:mm:ss'));
fprintf(fileid,'\r\n\r\t%s\r\n','====================== Parameter List ====================== ');
fprintf(fileid,'\r\n\r\t\r\t%s\r\t\r\t\r\t%s\r\n','Parameter Name','Value');
nPar = invoke(varargin{1},'GetNumberOfParameters');
for i = 0: nPar
    strPar =invoke(varargin{1}, 'GetParameterName',i);
    strValue= invoke(varargin{1},'RestoreParameterExpression',strPar);
    fprintf(fileid,'\r\n\r\t\r\t%s\r\t\r\t\r\t%s\r\n',strPar,strValue);
end
fprintf(fileid,'\r\n____________________________________________________________________________________\r\n ');
fclose(fileid);

end