[Mesh]
  type = GeneratedMesh
  dim = 3
  nx = 4
  ny = 4
  nz = 4
  xmin = 0
  xmax = 1
  ymin = 0
  ymax = 1
  zmin = 0
  zmax = 1
[]

[GlobalParams]
  displacements = 'disp_x disp_y disp_z'
  temperature = temp
[]

[Variables]
  [./temp]
    initial_condition = 0.0
  [../]
  [./disp_x]
  [../]
  [./disp_y]
  [../]
  [./disp_z]
  [../]
[]

[Kernels]
  [./T_diff]
    type = LynxHeatConduction
    variable = temp
  [../]
  [./mech_x]
    type = LynxSolidMomentum
    variable = disp_x
    component = 0
  [../]
  [./mech_y]
    type = LynxSolidMomentum
    variable = disp_y
    component = 1
  [../]
  [./mech_z]
    type = LynxSolidMomentum
    variable = disp_z
    component = 2
  [../]
[]

[AuxVariables]
  [./vol_strain]
    order = CONSTANT
    family = MONOMIAL
  [../]
[]

[AuxKernels]
  [./vol_strain_aux]
    type = LynxVolStrainAux
    variable = vol_strain
    strain_type = thermal
  [../]
[]

[BCs]
  [./T1_everywhere]
    type = PresetBC
    variable = temp
    boundary = 'left right front back bottom top'
    value = 100.0
  [../]
  [./no_x]
    type = PresetBC
    variable = disp_x
    boundary = left
    value = 0.0
  [../]
  [./no_y]
    type = PresetBC
    variable = disp_y
    boundary = bottom
    value = 0.0
  [../]
  [./no_z]
    type = PresetBC
    variable = disp_z
    boundary = back
    value = 0.0
  [../]
[]

[Materials]
  [./elastic_mat]
    type = LynxDeformation
    bulk_modulus = 1.0e+09
    shear_modulus = 1.0e+09
  [../]
  [./thermal]
    type = LynxThermalConstant
    solid_thermal_conductivity = 1.0
    solid_thermal_expansion = 1.0e-02
  [../]
[]

[Preconditioning]
  [./precond]
    type = SMP
    full = true
    petsc_options = '-snes_ksp_ew'
    petsc_options_iname = '-ksp_type -pc_type -snes_atol -snes_rtol -snes_max_it -ksp_max_it -sub_pc_type -sub_pc_factor_shift_type'
    petsc_options_value = 'gmres asm 1E-10 1E-10 200 500 lu NONZERO'
  [../]
[]

[Executioner]
  type = Transient
  solve_type = Newton
  start_time = 0.0
  end_time = 1
  dt = 1
[]

[Outputs]
  #execute_on = 'timestep_end'
  print_linear_residuals = true
  perf_graph = true
  exodus = true
[]