function parameters = mergeParameters(p1,p2)

nStarts1 = sum(~isnan(p1.MS.logPost));
nStarts2 = sum(~isnan(p2.MS.logPost));

p1 = sortMultiStarts(p1);
p2 = sortMultiStarts(p2);

parameters.name = p1.name;
parameters.number = p1.number;
parameters.min = p1.min;
parameters.max = p1.max;
parameters.constraints = p1.constraints;
parameters.MS.n_starts = nStarts1+nStarts2;


for i = 1:nStarts1
    parameters.MS.par0(:,i) = p1.MS.par0(:,i);
    parameters.MS.logPost0(i) = p1.MS.logPost0(i);
    parameters.MS.logPost(i) = p1.MS.logPost(i);
    parameters.MS.par(:,i) = p1.MS.par(:,i);
    parameters.MS.gradient(:,i) = p1.MS.gradient(:,i);
    parameters.MS.t_cpu(i) = p1.MS.t_cpu(i);
    parameters.MS.n_iter(i) = p1.MS.n_iter(i);
    parameters.MS.exitflag(i) = p1.MS.exitflag(i);
    parameters.MS.n_objfun(i) = p1.MS.n_objfun(i);
    parameters.MS.hessian(:,:,i) = p1.MS.hessian(:,:,i);
end


for i = 1:nStarts2
    parameters.MS.par0(:,i+nStarts1) = p2.MS.par0(:,i);
    parameters.MS.logPost0(i+nStarts1) = p2.MS.logPost0(i);
    parameters.MS.logPost(i+nStarts1) = p2.MS.logPost(i);
    parameters.MS.par(:,i+nStarts1) = p2.MS.par(:,i);
    parameters.MS.gradient(:,i+nStarts1) = p2.MS.gradient(:,i);
    parameters.MS.t_cpu(i+nStarts1) = p2.MS.t_cpu(i);
    parameters.MS.n_iter(i+nStarts1) = p2.MS.n_iter(i);
    parameters.MS.exitflag(i+nStarts1) = p2.MS.exitflag(i);
    parameters.MS.n_objfun(i+nStarts1) = p2.MS.n_objfun(i);
    parameters.MS.hessian(:,:,i+nStarts1) = p2.MS.hessian(:,:,i);
end
parameters.MS.t_cpu = parameters.MS.t_cpu';
parameters.MS.n_objfun = parameters.MS.n_objfun';
parameters.MS.n_iter = parameters.MS.n_iter';
parameters.MS.logPost = parameters.MS.logPost';
parameters.MS.logPost0 = parameters.MS.logPost0';
parameters.MS.exitflag = parameters.MS.exitflag';

parameters = sortMultiStarts(parameters);

end