function [model] = transfectionSusanne_amici_syms()

model.param = 'log10';

% STATES
syms mRNA GFP

x = [
mRNA GFP
];

% PARAMETERS
syms k1 k2 k3 noise

p = [k1 k2 k3 noise];

%CONSTANTS
syms mRNA0
k = [mRNA0];

% INPUT 
syms t

% SYSTEM EQUATIONS
xdot = sym(zeros(size(x)));

xdot(1) = -mRNA*k1;
xdot(2) = k2*mRNA - k3*GFP;

% INITIAL CONDITIONS
x0 = sym(zeros(size(x)));

x0(1) = mRNA0;

% OBSERVABLES
y = sym(zeros(2,1));

y(1) = log(mRNA);
y(2) = log(GFP);

% SYSTEM STRUCT
model.sym.x = x;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.k = k;
model.sym.x0 = x0;
model.sym.y = y;

model.sym.sigma_y = sym(size(model.sym.y));

model.sym.sigma_y(1) = noise;
model.sym.sigma_y(2) = noise;
end