clear all
close all
clc

%amiwrap('transfectionSusanne','transfectionSusanne_syms',pwd)

dataset=3;
importSusanneData

D.my = [mRNA(2:end),GFP(2:end)];
D.t = time(2:end);

options.MS = PestoOptions();
options.MS.localOptimizerOptions = optimset('algorithm','interior-point',...
    'display','iter',...
    'GradObj','on',...
    'MaxIter',2000,...
    'MaxFunEvals',6400,...
    'PrecondBandWidth', inf);
options.MS.n_starts = 20;
options.MS.HO.n_obs = 2;
options.MS.HO.noise = {'single','single'};
options.MS.HO.scaling = {'absolute','absolute'};
options.MS.HO.scale = {'log','log'};

%options.MS.HO.obsgroups_noise = {1,2};
%options.MS.HO.obsgroups_noise{1} = [1,2];

options.MS.HO.obsgroups_scaling = {1,2};

parameters.name = {'log_{10}(\delta)','log_{10}(k)','log_{10}(\gamma)'};

parameters.number = length(parameters.name);
parameters.min = -10*ones(parameters.number,1);
parameters.max = 3*ones(parameters.number,1);
%%
rng(2)
warning off
parameters = getMultiStarts(parameters,@(xi) ...
    logLikelihood_transfection(xi,D,options),options.MS);

parameters = getParameterProfiles(parameters,@(xi) ...
    logLikelihood_transfection(xi,D,options),options.MS);

options_plot = PestoPlottingOptions();
options_plot.A.plot_type = 0;
options_plot.MS.plot_type = 0;
plotParameterProfiles(parameters,[],[],[],options_plot)
set(gcf,'Color','w')

parameters = getParameterConfidenceIntervals(parameters,0.95);
parameters
save(['results_dataset' num2str(dataset)]);
%%
close all
figure
xi = log10([0.11,0.3,0.09]);
tsim = linspace(0,30);
sol = simulate_transfectionSusanne(tsim,xi,200);
xi = parameters.MS.par(:,1);
sol2 = simulate_transfectionSusanne(tsim,xi,200);
subplot(1,2,1);
plot(D.t,D.my(:,1),'k.'); hold on;
plot(sol.t,sol.y(:,1),'LineWidth',2); hold on;
plot(sol.t,sol2.y(:,1),'--','LineWidth',2); hold on;
ylabel('mRNA')
legend('data','true parameter','MLE')
xlabel('time');
subplot(1,2,2);
plot(D.t,D.my(:,2),'k.');hold on;
plot(sol.t,sol.y(:,2),'LineWidth',2); hold on;
plot(sol.t,sol2.y(:,2),'--','LineWidth',2); hold on;
ylabel('GFP')
xlabel('time');
hold on;
set(gcf,'Color','w')
