function [varargout] = logLikelihood_transfection_amici(xi,D,options)

try
    options.ami = amioption();
    if nargout>1
        options.ami.sensi = 1;
    else
        options.ami.sensi = 0;
    end
    
    %% SIMULATION
    sol = simulate_transfectionSusanne_amici(D.t,xi,[200],D,options.ami);
    lLH = sol.llh;
    if nargout > 1
        gradlLH = sol.sllh;
    end
    assert(isreal(lLH));
    assert(sol.status>=0)
catch error_thrown
    warning(['Evaluation of likelihood failed. ',error_thrown.message]);
    lLH = nan;
    gradlLH = nan(length(xi),1);
end

switch nargout
    case{0,1}
        varargout{1} = lLH;
    case 2
        varargout{1} = lLH;
        varargout{2} = gradlLH;
end
end

