function [varargout] = logLikelihood_transfection(xi,D,options)

try
    options.ami = amioption();
    if nargout>1
        options.ami.sensi = 1;
    else
        options.ami.sensi = 0;
    end
    
    %% SIMULATION
    sol = simulate_transfectionSusanne(D.t,xi(1:3),[200],[],options.ami);
    simulation(1).y = sol.y;
    if nargout > 1
        simulation(1).sy = sol.sy;
    end
    %% LOG-LIKELIHOOD, GRADIENT
    if nargout == 2
        [lLH, gradlLH] = logLikelihoodHierarchical(simulation,D,options.MS.HO);
    else
        lLH = logLikelihoodHierarchical(simulation,D,options.MS.HO);
    end
    assert(isreal(lLH));
    assert(sol.status>=0)
catch error_thrown
    warning(['Evaluation of likelihood failed. ',error_thrown.message]);
    lLH = nan;
    gradlLH = nan(length(xi),1);
end

switch nargout
    case{0,1}
        varargout{1} = lLH;
    case 2
        varargout{1} = lLH;
        varargout{2} = gradlLH;
end
end

