clear all
close all
clc

%% Load data
distributions = {'normal','laplace'};
%% Waterfall plot
for inddist = 1:2
    load(['./results/results_SmallJakStat_standard_' distributions{inddist} '.mat'])
    parameters_standard = parameters;
    converged(inddist,1) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    timeperconv(inddist,1) = nansum(parameters.MS.t_cpu)/converged(inddist,1);
    load(['./results/results_SmallJakStat_hierarchical_' distributions{inddist} '.mat'])
    parameters_hierarchical = parameters;
    converged(inddist,2) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    
    load(['./results/results_SmallJakStat_standard_' distributions{inddist} '_fminsearchbound.mat'],'parameters','D','options')
    parameters_standard_fminsearch = parameters;
    converged_pswarm(inddist,1) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    load(['./results/results_SmallJakStat_hierarchical_' distributions{inddist} '_fminsearchbound.mat'],'parameters','D','options')
    parameters_hierarchical_fminsearch = parameters;
    converged_pswarm(inddist,2) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    load_colors_hierarchical
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        col_h_pswarm = colors.h.normal_pswarm;
        col_s_pswarm = colors.s.normal_pswarm;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        col_h_pswarm = colors.h.laplace_pswarm;
        col_s_pswarm = colors.s.laplace_pswarm;
        lw = 1;
    end
    starts_h = parameters_standard.MS.logPost;
    starts_h(abs(starts_h-starts_h(1))>1e-1) = NaN;
    starts_h(~isnan(starts_h)) = 1;
    n_conv_starts_s = nansum(starts_h);
    figure(3);
     plot(-parameters_hierarchical.MS.logPost,'o-','MarkerSize',3,'Color',col_h);
    hold on
    plot(-parameters_standard.MS.logPost,'o-','MarkerSize',3,'Color',col_s);
    hold on
    
    plot(-parameters_hierarchical_fminsearch.MS.logPost,'d-','MarkerSize',3,'Color',col_h_pswarm);
    hold on
    plot(-parameters_standard_fminsearch.MS.logPost,'d-','MarkerSize',3,'Color',col_s_pswarm);
    hold on
    plot((1:2:100),-parameters_hierarchical_fminsearch.MS.logPost(1:2:end),....
        'd','MarkerSize',3,'Color',col_h_pswarm);
     plot((1:2:100),-parameters_hierarchical.MS.logPost(1:2:end),....
         'o','MarkerSize',3,'Color',col_h);
end
xlim([0,103]);
ylim([-80,20]);
xlabel('sorted optimizer runs','fontsize',setLay.ax.size)%,'FontName',setLay.lab.font)
ylabel('negative log-likelihood','fontsize',setLay.ax.size)%,'FontName',setLay.lab.font)
set(gca,'FontSize',setLay.ax.size,'TickDir','out')%,'FontName',setLay.lab.font)
set(gca,'Position',[0.2,0.2,0.6,0.6])%,'FontName',setLay.lab.font)
box off
%%
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 15 9])
print('-depsc','../figures/smallJakStat_waterfall_fminsearch')
xlim([0,40]);
ylim([-80,-50]);
set(gca,'ytick',[-80:10:-50])
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 9 5])
print('-depsc','../figures/smallJakStat_waterfallzoom_fminsearch')

