function [parameters,options] = getParameterOptions_ConversionReaction(approach)
% getParameterOptions_ConversionReaction() provides the parameters structs and
% options needed for the optimization.
%
% USAGE:
% [parameters,options] = getParameterOptions_ConversionReaction(approach)
%
% Parameters:
%  approach: 'hierarchical' or 'standard' approach for the optimization
%
% Return values
% parameters: with fields name, number, min and max
% options: with field MS a PestoOptions object and field llh a HOOptions
% object

options.MS = PestoOptions();
options.MS.n_starts = 100;
options.MS.mode = 'text';
options.MS.HO.n_obs = 1;
options.MS.HO.n_exp = 1;

options.MS.localOptimizerOptions = optimset('algorithm','interior-point',...
    'display','iter',...
    'GradObj','on',...
    'TolFun',1e-3,...
    'MaxIter',1000,...
    'MaxFunEvals',6400,...
    'PrecondBandWidth', inf);

load parameter_guesses_ConversionReaction par0

switch approach
    case 'hierarchical'
        parameters.name = {'log_{10}(k_1)','log_{10}(k_2)'};
        parameters.guess = par0(1:length(parameters.name),1:options.MS.n_starts);
        options.MS.HO.noise = {'single'};
        options.MS.HO.scaling = {'single'};
        options.MS.HO.obsgroups_noise = {1};
        options.MS.HO.obsgroups_scaling = {1};
    case 'standard'
        parameters.name = {'log_{10}(k_1)','log_{10}(k_2)','log_{10}(\sigma)','log_{10}(s)'};
        parameters.guess = par0(:,1:options.MS.n_starts);
        parameters.min = nan(parameters.number,1);
        parameters.max = nan(parameters.number,1);
        parameters.min(3) = -5;
        parameters.max(3) = 0;
        parameters.min(4) = -5;
        parameters.max(4) = 5;
end

parameters.number = length(parameters.name);
parameters.min(1:2) = -3.5;
parameters.max(1:2) = 1;