% Script for visualization results of the conversion reaction
clear all
close all
clc

load_colors_hierarchical

saveFlag = true;

%% Load data
figure(1)
distributions = {'normal'};
iMS = 1;
inddist = 1;
load(['../results/results_ConversionReaction_hierarchical_' distributions{inddist} '.mat'])
parameters_hierarchical = parameters;
options.MS.HO.save = true;
options.MS.foldername = pwd;
ll = logLikelihood_ConversionReaction(parameters_hierarchical.MS.par(:,iMS),D,options,approach);
load('analytical_results.mat')
load('../data/data_ConversionReaction.mat')

%% Simulation
tsim = linspace(D.t(1),D.t(end));
sol_h = simulate_ConversionReaction(tsim,parameters_hierarchical.MS.par(1:2,iMS));

%% Fit
col_h = colors.h.normal;
col_s = colors.s.normal;
lw = 1.3;

plot(tsim,s(1)*sol_h.y(:,1),'-','Color',[239,21,38]./250,'LineWidth',lw);hold on
iMS = 98;
ll = logLikelihood_ConversionReaction(parameters_hierarchical.MS.par(:,iMS),D,options,approach);
load('analytical_results.mat')
tsim = linspace(D.t(1),D.t(end));
sol_h = simulate_ConversionReaction(tsim,parameters_hierarchical.MS.par(1:2,iMS));

plot(tsim,s(1)*sol_h.y(:,1),'-','Color',[248,248,80]./250,'LineWidth',3);hold on
plot(D.t,D.my(:,1),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black'); hold on;

xlim([0 60]);
ylim([0 0.6]);
box off
set(gca,'FontSize',8,'XTick',[0,30,60],'TickDir','out');
xlabel('time [min]','FontSize',8);
ylabel('conc. of B [au]','FontSize',8);

set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 7.5 5.5])
    print('-depsc','../figures/ConversionReaction_fit_localvsglobal')

%%
[X,Y] = meshgrid(linspace(-3.5,1),linspace(-3.5,1));

for i = 1:size(X,1)
    i
    for j = 1:size(X,2)
        ll(i,j) = logLikelihood_ConversionReaction([X(i,j),Y(i,j)],D,options,approach);
    end
end

figure
%colormap(autumn)
contourf(linspace(-3.5,1),linspace(-3.5,1),ll);
colorbar
xlabel('log_{10}(k_1)')
ylabel('log_{10}(k_2)')

set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 13 10])
print('-depsc','../figures/ConversionReaction_contours')
%%
xi_loc = parameters_hierarchical.MS.par(1:2,iMS);
xi_loc(3) = log10(sqrt(noise));
xi_loc(4) = log10(s);

load(['../results/results_ConversionReaction_standard_' distributions{inddist} '.mat'])

options.MS.n_starts = 10;
parameters.guess = repmat(xi_loc,1,10);
parameters.guess(3:4,2:end) = parameters.guess(3:4,2:end) + 0.00000001*(rand(2,9)-0.5);

options.MS.foldername = ['./results/results_ConversionReaction_local_standard_normal'];
parameters = getMultiStarts(parameters,@(xi) ...
    logLikelihood_ConversionReaction(xi,D,options,approach),options.MS);
