% Script for visualization results of the conversion reaction
clear all
close all
clc

load_colors_hierarchical

saveFlag = true;

%% Load data
figure(1)
distributions = {'normal','laplace'};
iMS = 1;
for inddist = 1:2
    load(['../results/results_ConversionReaction_standard_' distributions{inddist} '.mat'])
    parameters_standard = parameters;
    load(['../results/results_ConversionReaction_hierarchical_' distributions{inddist} '.mat'])
    parameters_hierarchical = parameters;
    options.MS.HO.save = true;
    options.MS.foldername = pwd;
    ll = logLikelihood_ConversionReaction(parameters_hierarchical.MS.par(:,iMS),D,options,approach);
    load('analytical_results.mat')
    load('../data/data_ConversionReaction.mat')
    
    %% Simulation
    tsim = linspace(D.t(1),D.t(end));
    
    sol_s = simulate_ConversionReaction(tsim,parameters_standard.MS.par(1:2,iMS));
    sol_h = simulate_ConversionReaction(tsim,parameters_hierarchical.MS.par(1:2,iMS));
    
    %% Fit
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        lw = 1;
    end
    plot(tsim,s(1)*sol_h.y(:,1),'-','Color',col_h,'LineWidth',lw);hold on
    plot(tsim,10.^parameters_standard.MS.par(4,1)*sol_s.y(:,1),'--','Color',col_s,'LineWidth',lw);hold on
    plot(D.t,D.my(:,1),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black'); hold on;
    xlim([0 60]);
    ylim([0 0.6]);
    set(gca,'FontSize',8)
    set(gca,'XTick',[0,30,60],'TickDir','out');
    xlabel('time [min]','FontSize',8);
    ylabel('conc. of B [au]','FontSize',8);
    box off
end

if saveFlag
    set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 7.5 5.5])
    print('-depsc','../figures/ConversionReaction_fits')
end

%%



% %%
% % Waterfall plot
% for inddist = 1:2
%     load(['./results/results_ConversionReaction_standard_' distributions{inddist} '.mat'])
%     parameters_standard = parameters;
%     converged(inddist,1) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
%         /(sum(~isnan(parameters.MS.logPost)));
%     timeperconv(inddist,1) = nansum(parameters.MS.t_cpu)/converged(inddist,1);
%     load(['./results/results_ConversionReaction_hierarchical_' distributions{inddist} '.mat'])
%     parameters_hierarchical = parameters;
%     converged(inddist,2) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
%         /(sum(~isnan(parameters.MS.logPost)));
%     timeperconv(inddist,2) = nansum(parameters.MS.t_cpu)/converged(inddist,2);
%     load_colors_hierarchical
%     if inddist == 1
%         col_h = colors.h.normal;
%         col_s = colors.s.normal;
%         lw = 1.3;
%     else
%         col_h = colors.h.laplace;
%         col_s = colors.s.laplace;
%         lw = 1;
%     end
%     starts_h = parameters_standard.MS.logPost;
%     starts_h(abs(starts_h-starts_h(1))>1e-1) = NaN;
%     starts_h(~isnan(starts_h)) = 1;
%     n_conv_starts_s = nansum(starts_h);
%     figure(3);
%     plot(-parameters_hierarchical.MS.logPost,'o-','MarkerSize',3,'Color',col_h);
%     hold on
%     plot(-parameters_standard.MS.logPost,'o-','MarkerSize',3,'Color',col_s);
%     hold on
%     plot((1:2:100),-parameters_hierarchical.MS.logPost(1:2:end),....
%         'o','MarkerSize',3,'Color',col_h);
% end
% xlim([0,100]);
% ylim([-100,70]);
% set(gca,'FontSize',setLay.ax.size,'TickDir','out')
% box off
% set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 6.5 3.4])
% if saveFlag
%     print('-depsc','../figures/ConversionReaction_waterfall')
% end
% % xlim([0,40]);
% % ylim([-80,-66]);
% % set(gca,'ytick',[-80,-70])
% % set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 6.5 2])
% % if saveFlag
% %     print('-depsc','../figures/smallJakStat_waterfallzoom')
% %end
% 
% 


%% load statistics
distributions = {'normal','laplace'};
for inddist = 1:2
        load(['../results/results_ConversionReaction_standard_' distributions{inddist} '.mat'])
        parameters_standard = parameters;
        bests = parameters_standard.MS.logPost(1);
        clear parameters
        load(['../results/results_ConversionReaction_hierarchical_' distributions{inddist} '.mat'])
        parameters_hierarchical = parameters;
        besth = parameters_hierarchical.MS.logPost(1);
        clear parameters
        bestllh = max(parameters_hierarchical.MS.logPost(1),parameters_standard.MS.logPost(1));
        
        converged(1,inddist) = sum(2*(parameters_standard.MS.logPost-bestllh)...
            >-icdf('chi2',0.95,1))/(sum(~isnan(parameters_standard.MS.logPost)));
        cputimes{1,inddist} = parameters_standard.MS.t_cpu;
        
        timeperconv(1,inddist) = nansum(parameters_standard.MS.t_cpu)/...
            sum(2*(parameters_standard.MS.logPost-bestllh)...
            >-icdf('chi2',0.95,1));
        
        convpermin(1,inddist) = ...
            sum(2*(parameters_standard.MS.logPost-bestllh)...
            >-icdf('chi2',0.95,1))/nansum(parameters_standard.MS.t_cpu)*60;
        % hierarchical
        converged(2,inddist) = sum(2*(parameters_hierarchical.MS.logPost-bestllh)...
            >-icdf('chi2',0.95,1))/(sum(~isnan(parameters_hierarchical.MS.logPost)));
        
        timeperconv(2,inddist) = nansum(parameters_hierarchical.MS.t_cpu)/...
            sum(2*(parameters_hierarchical.MS.logPost-bestllh)...
            >-icdf('chi2',0.95,1));
        
        convpermin(2,inddist) = nansum(parameters_hierarchical.MS.t_cpu)/...
            sum(2*(parameters_hierarchical.MS.logPost-bestllh)...
            >-icdf('chi2',0.95,1))*60;
        
        cputimes{2,inddist} = parameters_hierarchical.MS.t_cpu;
        BICs(inddist) = -2*parameters_hierarchical.MS.logPost(1)+...
            log(sum(sum(~isnan(D.my))))*parameters_hierarchical.number;
        AICs(inddist) = -2*parameters_hierarchical.MS.logPost(1)+...
            2*parameters_hierarchical.number;
        [~,sind] = sort(parameters_standard.MS.par0(1,:));
        [~,hind] = sort(parameters_hierarchical.MS.par0(1,:));
        cpudiff = parameters_standard.MS.t_cpu(sind)-parameters_hierarchical.MS.t_cpu(hind);
        
        faster(1,inddist) = 100-length(find(cpudiff>0))/length(cpudiff)*100;
        faster(2,inddist) = length(find(cpudiff>0))/length(cpudiff)*100;
end
%%
figure;
subplot('Position',[0.1,0.55,0.8,0.16]);
b = bar([converged(:)';converged(:)']*100);
b(1).FaceColor = colors.s.normal;
b(3).FaceColor = colors.s.laplace;
b(2).FaceColor = colors.h.normal;
b(4).FaceColor = colors.h.laplace;
box off
set(gca,'TickDir','Out','FontSize',setLay.ax.size)
set(gca,'xtick',[],'xlim',[0.5,1.5]);

subplot('Position',[0.1,0.1,0.8,0.16]);
xplaces = [0.72,0.91,1.09,1.28];
xplaces(5:8) = [0.72,0.91,1.09,1.28]+1;
xplaces(9:12) = [0.72,0.91,1.09,1.28]+2;
plot(xplaces([1]),[convpermin(1)],...
    '.','MarkerSize',12,'color',colors.s.normal); hold on;
plot(xplaces([2]),[convpermin(2)],...
    '.','MarkerSize',12,'color',colors.h.normal)
plot(xplaces([3]),[convpermin(3)],...
    '.','MarkerSize',12,'color',colors.s.laplace)
plot(xplaces([4]),[convpermin(4)],...
    '.','MarkerSize',12,'color',colors.h.laplace)

set(gca,'yscale','log')
box off
set(gca,'TickDir','Out','FontSize',setLay.ax.size)
set(gca,'xtick',[],'xlim',[0.5,3.5],'ylim',[10^1,10^7],'ytick',10.^[1:7],...
    'yticklabel',{'10^1','','10^3','','10^5','','10^7'});


        subplot('Position',[0.1,0.28,0.8,0.25]);
    
    maxsizecputimes = 0;
    for i = 1:2
        for j = 1:2
            if numel(cputimes{i,j}) > maxsizecputimes
                maxsizecputimes = numel(cputimes{i,j});
            end
        end
    end
    for i = 1:2
        for j = 1:2
            if numel(cputimes{i,j}) < maxsizecputimes
                cputimes{i,j}(end:end+maxsizecputimes-numel(cputimes{i,j})) = NaN;
            end
        end
    end
    boxplot(([cputimes{1,1},...
        cputimes{2,1},...
        cputimes{1,2},...
        cputimes{2,2}]),'OutlierSize',6,'Symbol','k.','Width',0.8);hold on;
    boxes = findobj(gca,'Tag','Box');
    median = findobj(gca,'Tag','Median');
    patch(get(boxes(4),'XData'),get(boxes(4),'YData'),colors.s.normal,'FaceAlpha',1); hold on;
    patch(get(boxes(3),'XData'),get(boxes(3),'YData'),colors.h.normal,'FaceAlpha',1); hold on;
    patch(get(boxes(2),'XData'),get(boxes(2),'YData'),colors.s.laplace,'FaceAlpha',1); hold on;
    patch(get(boxes(1),'XData'),get(boxes(1),'YData'),colors.h.laplace,'FaceAlpha',1); hold on;
    plot(get(median(1),'XData'),get(median(1),'YData'),'k-','Linewidth',0.5); hold on;
    plot(get(median(2),'XData'),get(median(2),'YData'),'k-','Linewidth',0.5);
    plot(get(median(3),'XData'),get(median(3),'YData'),'k-','Linewidth',0.5);
    plot(get(median(4),'XData'),get(median(4),'YData'),'k-','Linewidth',0.5);
    set(gca,'yscale','log','xtick',[],'tickdir','out','FontSize',setLay.ax.size)
    %ylim([0.09,6]);
    xlim([-0.2,5.2])
    box off


