clear all
close all
clc

names = {'k_1','k_2'};
  
load_colors_hierarchical

load results_ConversionReaction_hierarchical_normal_optimizationPath
ph = parameters;

load results_ConversionReaction_standard_normal_optimizationPath
ps = parameters;

subplot('Position',[0.1,0.1,0.6,0.55])
colorsparam = hsv(11);
idx = find(isnan(ph.MS.fval_trace));

col_param_h = [0,144,81;148,33,147]./255;
col_param_s = [97,216,54;215,131,255]./255;

for i = 1:2
    plot(1:size(ps.MS.par_trace,2),ps.MS.par_trace(i,:),'Color',col_param_s(i,:)); hold on;
    plot(1:size(ph.MS.par_trace,2),ph.MS.par_trace(i,:),'--','Color',col_param_h(i,:)); hold on;
    plot(idx,ph.MS.par_trace(i,find(isnan(ph.MS.fval_trace),1,'first')-1)*ones(numel(idx),1)...
        ,':','Color',col_param_h(i,:)); hold on;
end
set(gca,'tickdir','out','fontsize',setLay.ax.size)
ylabel('log_{10}(\theta)','fontsize',setLay.ax.size)
xlabel('optimization step','fontsize',setLay.ax.size)
xlim([1,ph.MS.n_iter+1])
legend(names,'fontsize',setLay.ax.size)
box off
subplot('Position',[0.1,0.7,0.6,0.25])
plot(ps.MS.fval_trace,'Color',colors.s.normal); hold on;
plot(ph.MS.fval_trace,'--','Color',colors.h.normal); hold on;
plot(idx,ph.MS.fval_trace(find(isnan(ph.MS.fval_trace),1,'first')-1)*ones(numel(idx),1)...
    ,':','Color',colors.h.normal); hold on;

ylim([-80,65])
ylabel('negative log-likelihood','fontsize',setLay.ax.size)
box off
set(gca,'xticklabel','','tickdir','out','fontsize',setLay.ax.size)
xlim([0,ps.MS.n_iter+1])


set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 18 8])
print('-depsc','../figures/optimizationPath')
