function [] = visualize_histones_qqPlot(foldername, varargin)
% This function visualizes the qq plots and the correlation for varying
% offset values.

if nargin > 1
    saveFigures = varargin{1};
else
    saveFigures = false;
end

load_plot_settings

stroffsets = {'1em8','1em6','1em5','1em4','1em3','1em2','1em1','2em1',...
    '3em1','5em1','8em1','1','11em1','2','3','10'};
warning off
for iOff = 1:length(stroffsets)
    offsetvals(iOff) = str2num(strrep(stroffsets{iOff},'m','-'));
    filename = ['./' foldername '/findOffset/results_globalDemeth_CAL311_319_all_WT_offset' ...
        stroffsets{iOff}];
    load(filename,'parameters','options','simulateA','DA','sim_light','sim_all')
    simulateA = @(t,xi,k,options) ...
        simulate_histones_all_withpreequ(t,xi,k,options,sim_light,sim_all);
    % Simulate model and extract noise parameter from hierarchical
    % likelihood
    xi = parameters.MS.par(:,1);
    xiA = xi(1:options.llh.n_theta);
    solA = simulateA(DA.t,xiA,options.llh.input,options.ami);
    options.MS.HO.save = true;
    options.MS.HO.foldername = pwd;
    ll = logLikelihood_histones_hierarchical(xi,DA,simulateA,options);
    load(['analytical_results'])
    
    % Probability density function of the Laplace distribution used to
    % generate qq plot.
    f = @(x) 1/(2*noise(1))*exp(-abs(x)/noise(1));
    tmp = bsxfun(@minus,DA.my,solA.y);
    tmp = tmp(:);
    [fh{iOff},th_quant,emp_quant] = myqqplot(tmp,f,'pdf',color.global);
    qq_corr(iOff) = corr(th_quant(1:end-1)',emp_quant(1:end-1));
    if ~(isequal(iOff,2) || isequal(iOff,7))
        close(fh{iOff})
    end
end

%% Visualize some specific offsets (indices are hardcoded)
fh_corr = figure;
plot(offsetvals,qq_corr,'o-','MarkerSize',1,'Color',color.global); hold on;
xlabel('offset','FontSize',fs)
ylabel('qq-plot correlation','FontSize',fs)
set(gca,'xscale','log','FontSize',fs,'TickDir','out',...
    'ytick',[0.6,0.7,0.8,0.9,1],'yticklabel',{'0','0.7','0.8','0.9','1'},...
    'xtick',[1e-8,1e-4,1e0])
ylim([0.6,1])
xlim([offsetvals(1),offsetvals(end)])
box off
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 4.5 3])
if saveFigures
    print('-dpdf','./figures/globalDemeth_find_offset')
end
figure(fh{2})
if labelFlag
    title('offset 10^{-6}','FontSize',fs)
else
    xlabel('')
    ylabel('')
end
qq_corr(2)
set(gca,'FontSize',fs);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 3 3])
if saveFigures
    print('-dpdf','./figures/globalDemeth_find_offset_1em6')
end
figure(fh{7})
if labelFlag
    title('offset 10^{-1}','FontSize',fs)
else
    xlabel('')
    ylabel('')
end
qq_corr(7)
xlim([-0.8,1])
ylim([-0.8,1])
set(gca,'FontSize',fs,'xtick',[0,1],'ytick',[0,1]);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 3 3])
if saveFigures
    print('-dpdf','./figures/globalDemeth_find_offset_1em1')
end

%% Repeat same as above for domain model
stroffsets = {'1em6','1em2','1em1','2em1',...
    '3em1','5em1','8em1','2','3'};

for iOff = 1:length(stroffsets)
    offsetvals_dom(iOff) = str2num(strrep(stroffsets{iOff},'m','-'));
    filename = [foldername '/findOffset/results_15domains_CAL311_319_all_WT_offset' ...
        stroffsets{iOff}];
    load(filename,'parameters','options','simulateA','DA')
    
    xi = parameters.MS.par(:,1);
    xiA = xi(1:options.llh.n_theta);
    solA = simulateA(DA.t,xiA,options.llh.input,options.ami);
    options.MS.HO.save = true;
    ll = logLikelihood_histones_hierarchical(xi,DA,simulateA,options);
    load([options.MS.HO.foldername '/analytical_results'])
    
    f = @(x) 1/(2*noise(1))*exp(-abs(x)/noise(1));
    tmp = bsxfun(@minus,DA.my,solA.y);
    tmp = tmp(:);
    [fh{iOff},th_quant,emp_quant] = myqqplot(tmp,f,'pdf',color.domains);
    qq_corr_dom(iOff) = corr(th_quant(1:end-1)',emp_quant(1:end-1));
    if ~(isequal(iOff,1) || isequal(iOff,3))
        close(fh{iOff})
    end
    
end

figure(fh_corr)
plot(offsetvals,qq_corr,'o-','MarkerSize',1.5,'LineWidth',1.1,'Color',color.global); hold on;
plot(offsetvals_dom,qq_corr_dom,'o-','MarkerSize',1,'Color',color.domains)
xlabel('offset','FontSize',fs)
ylabel('qq-plot correlation','FontSize',fs)
set(gca,'xscale','log','FontSize',fs,'TickDir','out',...
    'ytick',[0.6,0.7,0.8,0.9,1],'yticklabel',{'0','0.7','0.8','0.9','1'},...
    'xtick',[1e-8,1e-4,1e0])
ylim([0.6,1])
xlim([offsetvals(1),offsetvals(end)])
box off
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 4.5 3])
if saveFigures
    print('-dpdf','./figures/domain_find_offset')
end

figure(fh{1})
if labelFlag
    title('offset 10^{-6}','FontSize',fs)
else
    xlabel('')
    ylabel('')
end
qq_corr_dom(1)
set(gca,'FontSize',fs);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 3 3])
if saveFigures
    print('-dpdf','./figures/domain_find_offset_1em6')
end
figure(fh{3})
if labelFlag
    title('offset 10^{-1}','FontSize',fs)
else
    xlabel('')
    ylabel('')
end
qq_corr_dom(3)
xlim([-0.8,1])
ylim([-0.8,1])
set(gca,'FontSize',fs,'xtick',[0,1],'ytick',[0,1]);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 3 3])
if saveFigures
    print('-dpdf','./figures/domain_find_offset_1em1')
end

