function fh = visualize_histones_comparison_untreatedRecovery(indDomain,varargin)
% This function generates Figure 3D, the model fit for generation 2 of
% untreated and recovery cells.

if nargin > 1
    saveFigures = varargin{1};
else
    saveFigures = false;
end

load domains
figurename = 'untr_rec_diff1_2_16_15';
try
    load(['./results/forwSel_' modelnames{indDomain} '_' figurename]);
catch e
    disp(e.message)
end

%% Set plotting options
load_plot_settings;
DA.generations = 1:3;
DB.generations = 2;
opts.plot.errorbars = 1;
opts.plot.errorbarwidth = 1;
opts.plot.stddev = 0;
opts.plot.model.lw = 0.7;
opts.plot.samefigure = 1;
opts.plot.legendflag = 0;
opts.llh.scale = 'log';
opts.plot.tsim = linspace(2,24+3,100);
opts.plot.A.color.data = 'k';
opts.plot.A.color.model = color.domains;
opts.plot.B.color.data = color.inh_me3;
opts.plot.B.color.model = color.medium_inh_2;
opts.plot.A.marker = '.';
opts.plot.B.marker = '.';
opts.plot.lw = 0.5;
opts.plot.title = false;
opts.plot.fs = 8;
opts.plot.A.markersize = 9;
opts.plot.B.markersize = 8;
opts.plot.pos_flag = true;
positions = load_positions();
opts.plot.positions = positions;
opts.llh=options.llh;

xi = parameters.MS.par(:,1);
opts.llh.input = options.llh.input;
opts.llh.n_theta = options.llh.n_theta;
opts.ami = options.ami;
opts.plot.B.ls = '---';
fh=plot_histones(xi,DA,DB,simulateA,simulateB,opts);
figure(fh{1})
fh{1}.Name = 'generation 1';
for s = 1:15
    subplot('Position',opts.plot.positions{s})
    ylim([0,35]);
    set(gca,'TickDir','out')
    if s <= 4
        ylim([0,30]);
    elseif s > 4 && s <= 8
        ylim([0,12]);
    elseif s > 8 && s <= 12
        ylim([0,35]);
    else
        ylim([0,35]);
    end
    xlim([-1,28])
    if ismember(s, [2,3,4,6,7,8,10,11,12,14,15]     )
        set(gca,'yticklabel','');
    end
end

set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_' figurename '_generation1'])
end

figure(fh{2})
fh{2}.Name = 'generation 2';
for s = 1:15
    subplot('Position',opts.plot.positions{s})
    set(gca,'TickDir','out')
    if s <= 4
        ylim([0,90]);
        set(gca,'ytick',[0,20,40,60,80]);
    elseif s > 4 && s <= 8
        ylim([0,30]);
    elseif s > 8 && s <= 12
        ylim([0,60]);
        set(gca,'ytick',[0,20,40,60]);
    else
        ylim([0,30]);
    end
    xlim([2,21])
    if ismember(s, [2,3,4,6,7,8,10,11,12,14,15] )
        set(gca,'yticklabel','');
    end

end

set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 10 10])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_' figurename '_generation2_mainmanuscript'])
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_' figurename '_generation2'])
end
figure(fh{3})
fh{3}.Name = 'generation 3';
for s = 1:15
    subplot('Position',opts.plot.positions{s})
        set(gca,'TickDir','out')
    if s <= 4
        ylim([0,50]);
    elseif s > 4 && s <= 8
        ylim([0,40]);
    elseif s > 8 && s <= 12
        ylim([0,40]);
    else
        ylim([0,10]);
    end
    xlim([-1,28])
    if ismember(s, [2,3,4,6,7,8,10,11,12,14,15]     )
        set(gca,'yticklabel','');
    end
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_' figurename '_generation3'])
end

