% Plotting routine for errorbars. Plots X versus Y with errorbars of size E
% and length xlength.
%
% USAGE:
% myerrorbar(X,Y,E,xlength)
%
% Parameters:
% X: Values at x-axis
% Y: Values at y-axis
% E: symmetric errorbars of size 2*E
% xlength: width of errorbar

function  [ldA,ldB] = myerrorbar_histones(varargin)

X = varargin{1};
Y = varargin{2};
E = varargin{3};
options = varargin{4};
dataset = varargin{5};
xlength = options.plot.errorbarwidth;

ldA = [];
ldB = [];

for k = 1:length(X)
    switch dataset
        case 'A'
            x = [X(k) - xlength, X(k) + xlength];
            y_h = [Y(k) + E(k), Y(k) + E(k)];
            line(x, y_h,'Color',options.plot.A.color.data,...
                'LineWidth',options.plot.lw); hold on;
            y_b = [Y(k) - E(k), Y(k) - E(k)];
            line(x, y_b,'Color',options.plot.A.color.data,...
                'LineWidth',options.plot.lw);
            line([X(k),X(k)],[Y(k)+E(k),Y(k)-E(k)],...
                'Color',options.plot.A.color.data,'LineWidth',options.plot.lw);
            ldA = plot(X(k),Y(k),options.plot.A.marker,...
                'MarkerSize',options.plot.A.markersize,...
                'LineWidth',options.plot.lw,...
                'color',options.plot.A.color.data);
        case 'B'
            x = [X(k) - xlength, X(k) + xlength];
            y_h = [Y(k) + E(k), Y(k) + E(k)];
            line(x, y_h,'Color',options.plot.B.color.data,...
                'LineWidth',options.plot.lw); hold on;
            y_b = [Y(k) - E(k), Y(k) - E(k)];
            line(x, y_b,'Color',options.plot.B.color.data,...
                'LineWidth',options.plot.lw);
            line([X(k),X(k)],[Y(k)+E(k),Y(k)-E(k)],...
                'LineWidth',options.plot.lw,...
                'Color',options.plot.B.color.data);
            if options.plot.B.marker == 'o' 
                error('some bug: with marker ''o'' the data points are not centered anymore')
            else
               ldB = plot(X(k),Y(k),options.plot.B.marker,...
                    'MarkerSize',options.plot.B.markersize,...
                    'color',options.plot.B.color.data);
            end
    end
end
end
