function flux = get_flux_domainModel(parameters,xi,options,simulateA,domains)
% This function calculates the flux for the domain model.


%% Get states of the considered model
combstr = {'00','01','02','03','10','11','12','13','20','21','22','23',...
    '30','31','32'};
count = 1;
for i = 1:15
    for j = 1:length(domains)
        reg = [str2num(domains{j}(1)),str2num(domains{j}(2))];
        state = [str2num(combstr{i}(1)),str2num(combstr{i}(2))];
        if reg(1) >= state(1) && reg(2) >= state(2)
            statesstr{count}=[combstr{i} '_' domains{j}];
            count = count+1;
        end
    end
end

%% Simulate system to steady state for generation 1
sol = simulateA(0,xi,options.llh.input,options.ami);

%% Extract steady state values for the states
stst = nan(4,4,4,4); % K27 methyl. x K36 methyl. x domain highest K27 x domain highest K36
for count = 1:length(statesstr)
        stst(str2num(statesstr{count}(1))+1,...
             str2num(statesstr{count}(2))+1,...
             str2num(statesstr{count}(4))+1,...
             str2num(statesstr{count}(5))+1) = sol.x(:,count)*100; % in %
end

%% Calculate fluxes for each transition/methylation
% Get indices of domain size parameters
indWs = [];
for iXi = 1:1:parameters.number
	if parameters.name{iXi}(1) == 'w'
        indWs = [indWs, iXi];
    end
end

flux = zeros(22,1);
for iRate = 1:22
    yMod = [str2num(parameters.name{iRate}(2)),str2num(parameters.name{iRate}(5))]; % K27: from to
    xMod =  [str2num(parameters.name{iRate}(3)),str2num(parameters.name{iRate}(6))]; % K36: from to
    
    for iDomain = 1:length(domains)
        % Get size of domain
        for iParam = 1:parameters.number
            if strcmp(parameters.name{iParam},['w' domains{iDomain}(1) '' ...
                    domains{iDomain}(2)])
                indW = iParam;
            end
        end
        
        % If reaction is present in domain -> add it to overall flux of
        % this reaction
        if yMod(2) <= str2num(domains{iDomain}(1)) && ...
                xMod(2) <= str2num(domains{iDomain}(2))
            flux(iRate) = flux(iRate) + 10.^xi(indW)/sum(10.^xi(indWs))*10.^xi(iRate)*...
                stst(yMod(1)+1,xMod(1)+1,str2num(domains{iDomain}(1))+1,...
                str2num(domains{iDomain}(2))+1);
        end
    end
end

% normalize flux
%flux = 100*flux./sum(flux);