function parameters =  fitting_histones_untreated_recovery(varargin)

% default options
opts_comparison.nStarts = 20;
opts_comparison.baseResultFile = [];
opts_comparison.differences = 'no';
opts_comparison.resultsFile = [];

if nargin >= 1
    opts_comparison = setdefault(varargin{1},opts_comparison);
end

if isempty(opts_comparison.baseResultFile)
    error(['File needs to be specified with the results of the model' ...
        'for which the untreated and recovery should be compared']);
end

load(opts_comparison.baseResultFile,'parameters','simulateA','sim_light',...
    'sim_all','options','opts_fitting')

clear DA DB D
load(['./data/CAL311312313_WT']);
DA = D;
DA.t = DA.t(DA.t<=24)+3;
DA.my = DA.my(1:length(DA.t),1:45,:)+options.llh.input;
DA.my = log(DA.my);
DA.my(isinf(DA.my))= NaN;
DA.my(5,16:30,:) = NaN; 
DA.obs_names = DA.modifications;
DA.name = ['CAL311312313 wt gen 1-3'];
indices = 16:30; % for generation 2
% Load recovery experiment
load(['./data/CAL311312313_Inh']);
% 16h only for generation 2
D.my = D.my(1:5,:,:);
D.my(5,:,:) = nan;
D.t = D.t(1:5);
DB = D;
DB.t = DA.t;
[~,matchTimepoints]=ismember(D.t+3,DA.t);
matchTimepoints = matchTimepoints(matchTimepoints>0);
DB.my = nan(length(DA.t),length(indices),size(DB.my,3));
DB.my(matchTimepoints,:,:) = D.my(matchTimepoints,indices,:)+options.llh.input;
DB.my = log(DB.my);
DB.my(isinf(DB.my))=NaN;
DB.obs_names = DB.modifications;
DB.name = ['CAL311-313 Rec'];
n_data = sum(sum(sum(~isnan(DA.my))))+sum(sum(sum(~isnan(DB.my))));

DA.generations = [1:3];
DB.generations = 2;

simulateA = @(t,xi,kappa,options) ...
    simulate_histones_all_withpreequ(t,xi,kappa,options,sim_light,sim_all);

eval(['simulateB = @(t,xi,kappa,options)' ...
    ' simulate_histones_' opts_fitting.modelname '_medium(t,xi,kappa,[],options)']);

%% define parameters
options.ami = amioption('sensi',0,'maxsteps',1e4);
options.MS = PestoOptions();
options.MS.localOptimizer = 'fmincon';
options.MS.localOptimizerOptions = optimset('GradObj','on',...
    'display','iter','TolFun',1e-10, 'TolX',1e-10, ...
    'MaxIter', 3000,'algorithm','interior-point');
options.MS.comp_type = 'sequential';
options.MS.save = true;
if isempty(opts_comparison.resultsFile)
    options.MS.foldername = ['./results/results_' opts_fitting.modelname ...
        '_untr_rec_' opts_comparison.differences];
else
    options.MS.foldername = opts_comparison.resultsFile;
end

options.MS.mode = 'text';

old_numParam = parameters.number;
switch opts_comparison.differences
    case 'allRates' 
        for count = 1:22
            parameters.name{end+1} = ['\\kappa_{' parameters.name{count} '}'];
            options.llh.diffB_xiind(count) = length(parameters.name);
            options.llh.diffB_theta{count} = count;
        end
    case 'allDomains' 
        count2 = 1;
        for count = 24:30
            parameters.name{end+1} = ['\\kappa_{' parameters.name{count} '}'];
            options.llh.diffB_xiind(count2) = length(parameters.name);
            options.llh.diffB_theta{count2} = count;
            count2 = count2+1;
        end
   case 'allParams' 
        for count = 1:30
            parameters.name{end+1} = ['\\kappa_{' parameters.name{count} '}'];
            options.llh.diffB_xiind(count) = length(parameters.name);
            options.llh.diffB_theta{count} = count;
        end
    case 'no'
        options.llh.diffB_theta = [];
        options.llh.diffB_xiind = [];
    case 'K27'
        count = 1;
        for iParam = 1:22
            if str2num(parameters.name{iParam}(5)) > str2num(parameters.name{iParam}(2))
                parameters.name{end+1} = ['\\kappa_{' parameters.name{iParam} '}'];
                options.llh.diffB_xiind(count) = length(parameters.name);
                options.llh.diffB_theta{count} = iParam;
                count = count+1;
            end
        end
    case 'K36'
        count = 1;
        for iParam = 1:22
            if str2num(parameters.name{iParam}(6)) > str2num(parameters.name{iParam}(3))
                parameters.name{end+1} = ['\\kappa_{' parameters.name{iParam} '}'];
                options.llh.diffB_xiind(count) = length(parameters.name);
                options.llh.diffB_theta{count} = iParam;
                count = count+1;
            end
        end
end
parameters.number = length(parameters.name);
parameters.max(old_numParam+1:parameters.number) = 6;
parameters.min(old_numParam+1:parameters.number) = -6;

n_obs = size(DA.my,2)+size(DB.my,2);
options.llh.n_states = n_obs;
options.MS.HO.n_obs = n_obs;
for i = 1:n_obs
    options.MS.HO.scaling{i} = 'absolute';
    options.MS.HO.noise{i} = 'single';
    options.MS.HO.scale{i} = 'lin';
    options.MS.HO.obsgroups_scaling{i} = i; 
end
options.MS.HO.max_repl = max(size(DA.my,3),size(DB.my,3));
options.MS.HO.obsgroups_noise = {[1:n_obs]};
options.MS.HO.distribution = 'laplace';
options.llh.prior.mean = nan;
options.llh.prior.sigma2 = nan;
%% Parameter estimation of model without differences
options.MS.n_starts = opts_comparison.nStarts;
guess = [parameters.MS.par(:,1:10);zeros(parameters.number-old_numParam,10)];
parameters.guess = [guess,getParameterGuesses(parameters,@(xi) ...
    logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options),...
    options.MS.n_starts-10, parameters.min, parameters.max,options.MS)];
parameters = getMultiStarts(parameters,@(xi) ...
    logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options),...
    options.MS);
parameters.MS.BIC = -2*parameters.MS.logPost+ ...
    log(n_data)*(parameters.number+1);
save(options.MS.foldername)
