function [] = compare_untreated_recovery()
offset = 0.1;
clear DA DB D
load(['./data/CAL311312313_WT']);
DA = D;
DA.t = DA.t(DA.t<=24)+3;
DA.my = DA.my(1:length(DA.t),1:45,:)+offset;
DA.my = log(DA.my);
DA.my(isinf(DA.my))= NaN;
DA.my(5,16:30,:) = NaN;
DA.obs_names = DA.modifications;
DA.name = ['CAL311312313 wt gen 1-3'];
indices = 16:30; % for generation 2
% Load recovery experiment
load(['./data/CAL311312313_Inh']);
% 16h only for generation 2
D.my = D.my(1:5,:,:);
D.my(5,:,:) = nan;
D.t = D.t(1:5);
DB = D;
DB.t = DA.t;
[~,matchTimepoints]=ismember(D.t+3,DA.t);
matchTimepoints = matchTimepoints(matchTimepoints>0);
DB.my = nan(length(DA.t),length(indices),size(DB.my,3));
DB.my(matchTimepoints,:,:) = D.my(matchTimepoints,indices,:)+offset;
DB.my = log(DB.my);
DB.my(isinf(DB.my))=NaN;
DB.obs_names = DB.modifications;
DB.name = ['CAL311-313 Rec'];
n_data = sum(sum(sum(~isnan(DA.my))))+sum(sum(sum(~isnan(DB.my))));
DA.generations = [1:3];
DB.generations = 2;
load_colors;
positions = load_positions();
opts.plot.positions = positions;
opts.plot.pos_flag = true;
opts.plot.errorbars = 1;
opts.plot.errorbarwidth = 1;
opts.plot.stddev = 0;
opts.plot.model.lw = 0.7;
opts.plot.samefigure = 1;
opts.plot.legendflag = 0;
opts.plot.tsim = linspace(0.1,24+3);
opts.plot.textflag = false;
opts.plot.A.color.data = color.medium;
opts.plot.A.color.model = color.medium;
opts.plot.B.color.data = color.medium_inh;
opts.plot.title = false;
opts.plot.fs = 6;
opts.plot.A.markersize = 6.5;
opts.llh.scale = 'log';
opts.llh.input = 0.1;
fh=plot_histones([],DA,DB,[],[],opts);

%% comparison using t-test
close(fh{1})
close(fh{3})
figure(fh{2})
for iObs = 1:15
    x1 = squeeze(exp(DA.my(:,iObs+15,:)-offset));
    x2 = squeeze(exp(DB.my(:,iObs,:)-offset));
    
    [hs(iObs),ps(iObs)] = ttest(x1(:),x2(:));
    subplot('Position',opts.plot.positions{iObs})
    title(['h=' num2str(hs(iObs)) ' ,pval=' num2str(ps(iObs))]);
end

%% comparison using t-test in log scale
fh_log=plot_histones([],DA,DB,[],[],opts);
close(fh_log{1})
close(fh_log{3})
figure(fh_log{2})
for iObs = 1:15
    x1 = squeeze(DA.my(:,iObs+15,:));
    x2 = squeeze(DB.my(:,iObs,:));
    
    [hs(iObs),ps(iObs)] = ttest(x1(:),x2(:));
    subplot('Position',opts.plot.positions{iObs})
    title(['h=' num2str(hs(iObs)) ' ,pval=' num2str(ps(iObs))]);
end

