function [AICs,BICs] = check_forwardSelection_untr_rec(baseModelFile,checkIndices)
% Anayze results of forward selection procedure.

load(baseModelFile)

parameters_base = parameters;
clear parameters;

n_data = sum(sum(sum(~isnan(DA.my))))+sum(sum(sum(~isnan(DB.my))));


numDiffsBase = length(options.llh.diffB_theta);
strDiffsBase = '';
for i = 1:numDiffsBase
    strDiffsBase = [strDiffsBase '' num2str(options.llh.diffB_theta{i}) '_'];
end

BICs = nan(numel(checkIndices),1);
AICs = nan(numel(checkIndices),1);

ind = 1;
for count = checkIndices  
    try
        load(['./results/forwSel_' opts_fitting.modelname '_untr_rec_diff' ...
            strDiffsBase '' num2str(count)],'parameters');
        BICs(ind) = -2*parameters.MS.logPost(1) + log(n_data)*(1+parameters.number);
        AICs(ind) = -2*parameters.MS.logPost(1) + 2*(1+parameters.number);
    catch
        BICs(ind) = nan;
        AICs(ind) = nan;
    end
        ind = ind+1;        
end