function parameters = mergeProfiles(p1,p2)
parameters = p1;
mode = 1;
switch mode
    case 1 %no new points added
        for i = 1:length(p1.P)
            ind12 = [ones(length(p1.P(i).R),1);2*ones(length(p2.P(i).R),1)];
            [paramvals,indsort] = sort([p1.P(i).par(i,:),p2.P(i).par(i,:)]);
            paramvals_all = [p1.P(i).par,p2.P(i).par];
            paramvals_all = paramvals_all(:,indsort);
            
            R = [p1.P(i).R,p2.P(i).R];
            R = R(indsort);
            ind12 = ind12(indsort);
            ind1 = find(ind12==1);
            ind2 = find(ind12==2);
            
            indUsed = 1;
            j=1;
            while j < length(ind12)-1
                if ind12(j) == ind12(j+1)
                    indUsed = [indUsed,j+1];
                    j = j+1;
                else
                    % does next point lie over or under the connecting line of one
                    % profile?
                    if ind12(j) == 1
                        tmp = ind1(ind1>j);
                    else
                        tmp = ind2(ind2>j);
                    end
                    % index of next point belonging to p1
                    if isempty(tmp)
                       indUsed = [indUsed,j+1];
                       j = j+1;
                    else
                        nextPoint = tmp(1);
                        pointsBetween = [j+1:nextPoint-1];
                        flagBetween = 0;
                        for k = 1:numel(pointsBetween)
                            if (R(nextPoint) - R(j))/(paramvals(nextPoint)-paramvals(j))*paramvals(pointsBetween(k)) + ...
                                    (paramvals(nextPoint)*R(j) - paramvals(j)*R(nextPoint))/(paramvals(nextPoint)-paramvals(j)) ...
                                    < R(pointsBetween(k)) && ~flagBetween
                                indUsed = [indUsed,pointsBetween(k)];
                                j = pointsBetween(k);
                                flagBetween = 1;
                            end
                        end
                        if ~flagBetween
                            indUsed = [indUsed,nextPoint];
                            j = nextPoint;
                        end
                    end
                    
                end
            end
            %warning('fix')
            parameters.P(i).par = paramvals_all(:,indUsed);
            parameters.P(i).R = R(indUsed);

%             figure
%              plot(p1.P(i).par(i,:),p1.P(i).R,'o-');hold on;
%              plot(p2.P(i).par(i,:),p2.P(i).R,'o-');
%              plot(paramvals(indUsed),R(indUsed),'--');
        end
    case 2 %new points added
                for i = 1:length(p1.P)
            
            ind12 = [ones(length(p1.P(i).R),1);2*ones(length(p2.P(i).R),1)];
            [paramvals,indsort] = sort([p1.P(i).par(i,:),p2.P(i).par(i,:)]);
            R = [p1.P(i).R,p2.P(i).R];
            R = R(indsort);
            ind12 = ind12(indsort);
            ind1 = find(ind12==1);
            ind2 = find(ind12==2);
            
            paramvals_ret = paramvals(1); 
            R_ret = R(1);
            j=1;
            while j < length(ind12)-1
                if ind12(j) == ind12(j+1)
                    paramvals_ret = [indUsed,j+1];
                    j = j+1;
                else
                    % does next point lie over or under the connecting line of one
                    % profile?
                    if ind12(j) == 1
                        tmp = ind1(ind1>j);
                    else
                        tmp = ind2(ind2>j);
                    end
                    % index of next point belonging to p1
                    nextPoint = tmp(1);
                    pointsBetween = [j+1:nextPoint-1];
                    flagBetween = 0;
                    for k = 1:numel(pointsBetween)
                        if (R(nextPoint) - R(j))/(paramvals(nextPoint)-paramvals(j))*paramvals(pointsBetween(k)) + ...
                                (paramvals(nextPoint)*R(j) - paramvals(j)*R(nextPoint))/(paramvals(nextPoint)-paramvals(j)) ...
                                < R(pointsBetween(k)) && ~flagBetween
                            indUsed = [indUsed,pointsBetween(k)];
                            j = pointsBetween(k);
                            flagBetween = 1;
                        end
                    end
                    if ~flagBetween
                        indUsed = [indUsed,nextPoint];
                        j = nextPoint;
                    end
                end
            end
            
            figure
            plot(p1.P(i).par(i,:),p1.P(i).R,'o-');hold on;
            plot(p2.P(i).par(i,:),p2.P(i).R,'o-');
            plot(paramvals_ret(indUsed),R_ret(indUsed),'--');
        end
end
end

