function [model] = transfectionSusanne_syms()

model.param = 'log10';

% STATES
syms mRNA GFP

x = [
mRNA GFP
];

% PARAMETERS
syms k1 k2 k3

p = [k1 k2 k3];

%CONSTANTS
syms mRNA0
k = [mRNA0];

% INPUT 
syms t

% SYSTEM EQUATIONS
xdot = sym(zeros(size(x)));

xdot(1) = -mRNA*k1;
xdot(2) = k2*mRNA - k3*GFP;

% INITIAL CONDITIONS
x0 = sym(zeros(size(x)));

x0(1) = mRNA0;

% OBSERVABLES
y = sym(zeros(2,1));

y(1) = mRNA;
y(2) = GFP;

% SYSTEM STRUCT
model.sym.x = x;
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.k = k;
model.sym.x0 = x0;
model.sym.y = y;
end