function [] = rerunEstimation_JakStat_laplace(varargin)

approach = varargin{1};
distribution = 'laplace';

load('data_JakStat.mat')

load(['resultsserver_SmallJakStat_' approach '_' distribution])
options.MS.foldername = ['rerun_resultsserver_SmallJakStat_' approach '_' distribution];
options.MS.n_starts = 10;
options.MS.objOutNumber = 2;
options.MS.localOptimizerOptions = optimset('algorithm','trust-region-reflective',...
        'display','iter',...
        'GradObj','on',...
        'TolX',0,...
        'TolFun',1e-10,...
        'Hessian','off',...
        'MaxIter',3000,...
        'MaxFunEvals',10000,...
        'PrecondBandWidth', inf);
    
parameters.guess = parameters.MS.par(:,1:10);

parameters = getMultiStarts(parameters,@(xi) ...
    logLikelihood_JakStat(xi,D,options,approach),options.MS);

save(options.MS.foldername,'parameters','D','options','optimizer','approach')

end