% Script for visualization results of JakStat signaling I.

clear all
close all
clc

kappa(1) = 1.4; % Omega_cyt
kappa(2) = 0.45; % Omega_nuc
kappa(3) = 1; % init_STAT
load_colors_hierarchical

saveFlag = true;

%% Load data
figure(1)
distributions = {'normal','laplace'};

for inddist = 1:2
    load(['../results/results_SmallJakStat_standard_' distributions{inddist} '.mat'])
    parameters_standard = parameters;
    load(['../results/results_SmallJakStat_hierarchical_' distributions{inddist} '.mat'])
    parameters_hierarchical = parameters;
    options.MS.HO.save = true;
    options.MS.foldername = pwd;
    ll = logLikelihood_JakStat(parameters_hierarchical.MS.par(:,1),D,options,approach);
    load('analytical_results.mat')
    load('../data/data_JakStat.mat')
    
    %% Simulation
    tsim = (0:0.5:60)';
    
    sol_n = simulate_JakStat(tsim,parameters_standard.MS.par(1:14,1),kappa,[]);
    sol_r = simulate_JakStat_hierarchical(tsim,parameters_hierarchical.MS.par(1:11,1),kappa,[]);
    
    %% Fit
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        lw = 1;
    end
    s1 = subplot('Position',[0.1 0.7 0.7 0.25]);
    plot(tsim,s(1)*sol_r.y(:,1),'Color',col_h,'LineWidth',lw);hold on
    plot(tsim,sol_n.y(:,1),'--','Color',col_s,'LineWidth',lw);hold on
    plot(D.t,D.my(:,1),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black');
    xlim([0 60]);
    ylim([0 1.1]);
    set(gca,'FontSize',setLay.ax.size)
    set(gca,'XTick',(0:10:60),'XtickLabel',{''},'TickDir','out');
    box off
    
    s2 = subplot('Position',[0.1 0.4 0.7 0.25]);
    plot(tsim,s(2)*sol_r.y(:,2),'Color',col_h,'LineWidth',lw);hold on
    plot(tsim,sol_n.y(:,2),'--','Color',col_s,'LineWidth',lw);hold on
    plot(D.t,D.my(:,2),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black');
    xlim([0 60]);
    ylim([0 1.1]);
    set(gca,'FontSize',setLay.ax.size)
    set(gca,'XTick',(0:10:60),'XtickLabel',{''},'TickDir','out');
    box off
    
    s3 = subplot('Position',[0.1 0.1 0.7 0.25]);
    plot(tsim,sol_r.y(:,3),'Color',col_h,'LineWidth',lw);hold on
    plot(tsim,sol_n.y(:,3),'--','Color',col_s,'LineWidth',lw);hold on
    plot(D.t,D.my(:,3),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black');
    xlim([0 60]);
    ylim([0 1.1]);
    set(gca,'FontSize',setLay.ax.size)
    set(gca,'XTick',(0:10:60),'TickDir','out');
    box off
end
if saveFlag
    set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 7.5 5.5])
    print('-depsc','../../figures/smallJakStat_fit')
end

% Waterfall plot
for inddist = 1:2
    load(['./results/results_SmallJakStat_standard_' distributions{inddist} '.mat'])
    parameters_standard = parameters;
    converged(inddist,1) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    timeperconv(inddist,1) = nansum(parameters.MS.t_cpu)/converged(inddist,1);
    load(['./results/results_SmallJakStat_hierarchical_' distributions{inddist} '.mat'])
    parameters_hierarchical = parameters;
    converged(inddist,2) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    timeperconv(inddist,2) = nansum(parameters.MS.t_cpu)/converged(inddist,2);
    load_colors_hierarchical
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        lw = 1;
    end
    starts_h = parameters_standard.MS.logPost;
    starts_h(abs(starts_h-starts_h(1))>1e-1) = NaN;
    starts_h(~isnan(starts_h)) = 1;
    n_conv_starts_s = nansum(starts_h);
    figure(3);
    plot(-parameters_hierarchical.MS.logPost,'o-','MarkerSize',3,'Color',col_h);
    hold on
    plot(-parameters_standard.MS.logPost,'o-','MarkerSize',3,'Color',col_s);
    hold on
    plot((1:2:100),-parameters_hierarchical.MS.logPost(1:2:end),....
        'o','MarkerSize',3,'Color',col_h);
end
xlim([0,100]);
ylim([-100,70]);
set(gca,'FontSize',setLay.ax.size,'TickDir','out')
box off
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 6.5 3.4])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfall')
end
xlim([0,40]);
ylim([-80,-66]);
set(gca,'ytick',[-80,-70])
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 6.5 2])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfallzoom')
end

%% Waterfall plot visualization for PSwarm
figure('Name','pswarm');
for inddist = 1:2
    load(['./results/results_SmallJakStat_standard_' distributions{inddist} '_pswarm.mat'],'parameters','D','options','kappa')
    parameters_standard = parameters;
    converged(inddist,1) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    load(['./results/results_SmallJakStat_hierarchical_' distributions{inddist} '_pswarm.mat'],'parameters','D','options','kappa')
    parameters_hierarchical = parameters;
    converged(inddist,2) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    load_colors_hierarchical
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        lw = 1;
    end
    starts_h = parameters_standard.MS.logPost;
    starts_h(abs(starts_h-starts_h(1))>1e-1) = NaN;
    starts_h(~isnan(starts_h)) = 1;
    n_conv_starts_s = nansum(starts_h);
    plot(-parameters_hierarchical.MS.logPost,'o-','MarkerSize',3,'Color',col_h);
    hold on
    plot(-parameters_standard.MS.logPost,'o-','MarkerSize',3,'Color',col_s);
    hold on
    plot((1:2:100),-parameters_hierarchical.MS.logPost(1:2:end),....
        'o','MarkerSize',3,'Color',col_h);
end
xlim([0,103]);
ylim([-80,20]);
xlabel('sorted optimizer runs','fontsize',setLay.ax.size)
ylabel('negative log-likelihood','fontsize',setLay.ax.size)
set(gca,'FontSize',setLay.ax.size,'TickDir','out')
set(gca,'Position',[0.2,0.2,0.6,0.6])
box off
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 15 9])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfall_pswarm')
end
xlim([0,40]);
ylim([-80,-50]);
set(gca,'ytick',[-80:10:-50])
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 9 5])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfallzoom_pswarm')
end

%% Plot Profiles
saveFlag = true;
fsprofile = 7;
figure('name','profiles normal')
load('../results/results_SmallJakStat_standard_normal.mat')
ps = parameters;
load('../results/results_SmallJakStat_hierarchical_normal.mat')
ph = parameters;
figure
for i = 1:ph.number
    subplot(4,3,i)
    plot(ph.P(i).par(i,:),ph.P(i).R,'Color',colors.h.normal,'LineWidth',1); hold on;
    plot(ps.P(i).par(i,:),ps.P(i).R,'--','Color',colors.s.normal,'LineWidth',0.9)
    ylim([0,1.05])
    box off
    xlabel(ph.name{i},'fontsize',fsprofile)
    if ~ismember(i,[1,4,7,10])
        ylabel('')
        set(gca,'yticklabel','','fontsize',fsprofile)
    else
        %ylabel('likelihood ratio','fontsize',setLay.ax.size)
    end
    set(gca,'TickDir','out','fontsize',fsprofile)
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 8 9])
if saveFlag
    print('-depsc','../../figures/smallJakStat_profiles_normal_thesis')
end

%% Profiles laplace
figure('name','profiles laplace')
load('../results/results_SmallJakStat_standard_laplace.mat')
ps = parameters;

load('../results/results_SmallJakStat_hierarchical_laplace.mat')
ph = parameters;

for i = 1:ph.number
    subplot(4,3,i)
    % hierarchical
    plot(ph.P(i).par(i,:),ph.P(i).R,'Color',colors.h.laplace,'LineWidth',1); hold on;

    plot(ps.P(i).par(i,:),ps.P(i).R,'--','Color',colors.s.laplace,'LineWidth',0.9); hold on;

    ylim([0,1.05])
    box off
    xlabel(ph.name{i},'fontsize',fsprofile)
    if ~ismember(i,[1,4,7,10])
        ylabel('')
        set(gca,'yticklabel','','fontsize',fsprofile)
    else
        %ylabel('likelihood ratio','fontsize',setLay.ax.size)
    end
    set(gca,'TickDir','out','fontsize',fsprofile)
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 8 9])
if saveFlag
    print('-depsc','../../figures/smallJakStat_profiles_laplace_thesis')
end

%%
clear all
close all
clc
names = {'p_1','p_2','p_3','p_4','sp_1','sp_2','sp_3','sp_4','sp_5',...
            'offset_{tSTAT}','offset_{pSTAT}'};
  
load_colors_hierarchical

load results_trace_SmallJakStat_hierarchical_normal
ph = parameters;

load results_trace_SmallJakStat_standard_normal
ps = parameters;

subplot('Position',[0.1,0.1,0.6,0.55])
colorsparam = hsv(11);
idx = find(isnan(ph.MS.fval_trace));
for i = 1:11
    plot(1:size(ps.MS.par_trace,2),ps.MS.par_trace(i,:),'Color',colorsparam(i,:)); hold on;
    plot(1:size(ph.MS.par_trace,2),ph.MS.par_trace(i,:),'--','Color',colorsparam(i,:)); hold on;
    plot(idx,ph.MS.par_trace(i,find(isnan(ph.MS.fval_trace),1,'first')-1)*ones(numel(idx),1)...
        ,':','Color',colorsparam(i,:)); hold on;
end
set(gca,'tickdir','out','fontsize',setLay.ax.size)
%ylabel('log_{10}(\theta)','fontsize',setLay.ax.size)
%xlabel('optimization step','fontsize',setLay.ax.size)
xlim([1,ps.MS.n_iter+1])
%legend(names,'fontsize',setLay.ax.size)
box off
subplot('Position',[0.1,0.7,0.6,0.25])
plot(ps.MS.fval_trace,'Color',colors.s.normal); hold on;
plot(ph.MS.fval_trace,'--','Color',colors.h.normal); hold on;
plot(idx,ph.MS.fval_trace(find(isnan(ph.MS.fval_trace),1,'first')-1)*ones(numel(idx),1)...
    ,':','Color',colors.h.normal); hold on;

ylim([-80,65])
%ylabel('negative log-likelihood','fontsize',setLay.ax.size)
box off
set(gca,'xticklabel','','tickdir','out','fontsize',setLay.ax.size)
xlim([0,ps.MS.n_iter+1])

set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 18 8])
print('-depsc','../../figures/optimizationPath_thesis')
