% Script for visualization results of JakStat signaling I.

clear all
close all
clc

kappa(1) = 1.4; % Omega_cyt
kappa(2) = 0.45; % Omega_nuc
kappa(3) = 1; % init_STAT
load_colors_hierarchical

saveFlag = true;

%% Load data
figure(1)
distributions = {'normal','laplace'};

for inddist = 1:2
    load(['./results/results_SmallJakStat_standard_' distributions{inddist} '.mat'])
    parameters_standard = parameters;
    load(['./results/results_SmallJakStat_hierarchical_' distributions{inddist} '.mat'])
    parameters_hierarchical = parameters;
    options.MS.HO.save = true;
    options.MS.foldername = pwd;
    ll = logLikelihood_JakStat(parameters_hierarchical.MS.par(:,1),D,options,approach);
    load('analytical_results.mat')
    load('./data/data_JakStat.mat')
    
    %% Simulation
    tsim = (0:0.5:60)';
    
    sol_n = simulate_JakStat(tsim,parameters_standard.MS.par(1:14,1),kappa,[]);
    sol_r = simulate_JakStat_hierarchical(tsim,parameters_hierarchical.MS.par(1:11,1),kappa,[]);
    
    %% Fit
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        lw = 1;
    end
    s1 = subplot('Position',[0.1 0.7 0.8 0.25]);
    plot(tsim,s(1)*sol_r.y(:,1),'Color',col_h,'LineWidth',lw);hold on
    plot(tsim,sol_n.y(:,1),'--','Color',col_s,'LineWidth',lw);hold on
    plot(D.t,D.my(:,1),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black');
    xlim([0 60]);
    ylim([0 1.1]);
    set(gca,'FontSize',setLay.ax.size)
    set(gca,'XTick',(0:10:60),'XtickLabel',{''},'TickDir','out');
    box off
    
    s2 = subplot('Position',[0.1 0.4 0.8 0.25]);
    plot(tsim,s(2)*sol_r.y(:,2),'Color',col_h,'LineWidth',lw);hold on
    plot(tsim,sol_n.y(:,2),'--','Color',col_s,'LineWidth',lw);hold on
    plot(D.t,D.my(:,2),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black');
    xlim([0 60]);
    ylim([0 1.1]);
    set(gca,'FontSize',setLay.ax.size)
    set(gca,'XTick',(0:10:60),'XtickLabel',{''},'TickDir','out');
    box off
    
    s3 = subplot('Position',[0.1 0.1 0.8 0.25]);
    plot(tsim,sol_r.y(:,3),'Color',col_h,'LineWidth',lw);hold on
    plot(tsim,sol_n.y(:,3),'--','Color',col_s,'LineWidth',lw);hold on
    plot(D.t,D.my(:,3),'.','MarkerSize',8,'MarkerEdgeColor','black','MarkerFaceColor','black');
    xlim([0 60]);
    ylim([0 1.1]);
    set(gca,'FontSize',setLay.ax.size)
    set(gca,'XTick',(0:10:60),'TickDir','out');
    box off
end
if saveFlag
    set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 9 5])
    print('-depsc','../figures/smallJakStat_fit')
end

% Waterfall plot
for inddist = 1:2
    load(['./results/results_SmallJakStat_standard_' distributions{inddist} '.mat'])
    parameters_standard = parameters;
    converged(inddist,1) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    timeperconv(inddist,1) = nansum(parameters.MS.t_cpu)/converged(inddist,1);
    load(['./results/results_SmallJakStat_hierarchical_' distributions{inddist} '.mat'])
    parameters_hierarchical = parameters;
    converged(inddist,2) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    timeperconv(inddist,2) = nansum(parameters.MS.t_cpu)/converged(inddist,2);
    load_colors_hierarchical
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        lw = 1;
    end
    starts_h = parameters_standard.MS.logPost;
    starts_h(abs(starts_h-starts_h(1))>1e-1) = NaN;
    starts_h(~isnan(starts_h)) = 1;
    n_conv_starts_s = nansum(starts_h);
    figure(3);
    plot(-parameters_hierarchical.MS.logPost,'o-','MarkerSize',3,'Color',col_h);
    hold on
    plot(-parameters_standard.MS.logPost,'o-','MarkerSize',3,'Color',col_s);
    hold on
    plot((1:2:100),-parameters_hierarchical.MS.logPost(1:2:end),....
        'o','MarkerSize',3,'Color',col_h);
end
xlim([0,100]);
ylim([-100,70]);
set(gca,'FontSize',setLay.ax.size,'TickDir','out')
box off
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 6.5 3.4])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfall')
end
xlim([0,40]);
ylim([-80,-66]);
set(gca,'ytick',[-80,-70])
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 6.5 2])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfallzoom')
end

%% Waterfall plot visualization for PSwarm
figure('Name','pswarm');
for inddist = 1:2
    load(['./results/results_SmallJakStat_standard_' distributions{inddist} '_pswarm.mat'],'parameters','D','options','kappa')
    parameters_standard = parameters;
    converged(inddist,1) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    load(['./results/results_SmallJakStat_hierarchical_' distributions{inddist} '_pswarm.mat'],'parameters','D','options','kappa')
    parameters_hierarchical = parameters;
    converged(inddist,2) = sum(2*(parameters.MS.logPost-parameters.MS.logPost(1))>-icdf('chi2',0.95,1))...
        /(sum(~isnan(parameters.MS.logPost)));
    load_colors_hierarchical
    if inddist == 1
        col_h = colors.h.normal;
        col_s = colors.s.normal;
        lw = 1.3;
    else
        col_h = colors.h.laplace;
        col_s = colors.s.laplace;
        lw = 1;
    end
    starts_h = parameters_standard.MS.logPost;
    starts_h(abs(starts_h-starts_h(1))>1e-1) = NaN;
    starts_h(~isnan(starts_h)) = 1;
    n_conv_starts_s = nansum(starts_h);
    plot(-parameters_hierarchical.MS.logPost,'o-','MarkerSize',3,'Color',col_h);
    hold on
    plot(-parameters_standard.MS.logPost,'o-','MarkerSize',3,'Color',col_s);
    hold on
    plot((1:2:100),-parameters_hierarchical.MS.logPost(1:2:end),....
        'o','MarkerSize',3,'Color',col_h);
end
xlim([0,103]);
ylim([-80,20]);
xlabel('sorted optimizer runs','fontsize',setLay.ax.size)
ylabel('negative log-likelihood','fontsize',setLay.ax.size)
set(gca,'FontSize',setLay.ax.size,'TickDir','out')
set(gca,'Position',[0.2,0.2,0.6,0.6])
box off
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 15 9])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfall_pswarm')
end
xlim([0,40]);
ylim([-80,-50]);
set(gca,'ytick',[-80:10:-50])
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 9 5])
if saveFlag
    print('-depsc','../figures/smallJakStat_waterfallzoom_pswarm')
end

%% Plot Profiles
figure('name','profiles normal')
load('./results/results_SmallJakStat_standard_normal.mat')
ps = parameters;
load('./results/results_SmallJakStat_hierarchical_normal.mat')
ph = parameters;
figure
for i = 1:ph.number
    subplot(4,3,i)
    plot(ph.P(i).par(i,:),ph.P(i).R,'Color',colors.h.normal,'LineWidth',1); hold on;
    plot(ps.P(i).par(i,:),ps.P(i).R,'--','Color',colors.s.normal,'LineWidth',0.9)
    ylim([0,1.05])
    box off
    xlabel(ph.name{i})
    if ~ismember(i,[1,4,7,10])
        ylabel('')
        set(gca,'yticklabel','','fontsize',setLay.ax.size)
    else
        ylabel('likelihood ratio','fontsize',setLay.ax.size)
    end
    set(gca,'TickDir','out','fontsize',setLay.ax.size)
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 8.5 8])
if saveFlag
    print('-depsc','../figures/smallJakStat_profiles_normal')
end

%% Profiles laplace
figure('name','profiles laplace')
load('./results/results_SmallJakStat_standard_laplace.mat')
ps = parameters;

load('./results/results_SmallJakStat_hierarchical_laplace.mat')
ph = parameters;

for i = 1:ph.number
    subplot(4,3,i)
    % hierarchical
    plot(ph.P(i).par(i,:),ph.P(i).R,'Color',colors.h.laplace,'LineWidth',1); hold on;
%     for j = 1:numel(ph.MS.logPost)
%         if exp(ph.MS.logPost(j)-ph.MS.logPost(1)) > 0.05
%             plot(ph.MS.par(i,j),exp(ph.MS.logPost(j)-ph.MS.logPost(1)),'.',...
%                 'Color',colors.h.laplace); hold on;
%         end
%     end
    % standard
    plot(ps.P(i).par(i,:),ps.P(i).R,'--','Color',colors.s.laplace,'LineWidth',0.9); hold on;
%     for j = 1:numel(ps.MS.logPost)
%         if exp(ps.MS.logPost(j)-ps.MS.logPost(1)) > 0.05
%             plot(ps.MS.par(i,j),exp(ps.MS.logPost(j)-ps.MS.logPost(1)),'.',...
%                 'Color',colors.s.laplace); hold on;
%         end
%     end
    ylim([0,1.05])
    box off
    xlabel(ph.name{i})
    if ~ismember(i,[1,4,7,10])
        ylabel('')
        set(gca,'yticklabel','','fontsize',setLay.ax.size)
    else
        ylabel('likelihood ratio','fontsize',setLay.ax.size)
    end
    set(gca,'TickDir','out','fontsize',setLay.ax.size)
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 8.5 8])
if saveFlag
    print('-depsc','../figures/smallJakStat_profiles_laplace')
end

