clear all
close all
clc

load results_SmallJakStat_standard_normal
psn = parameters;
load merged_profiles_SmallJakStat_standard_laplace
psl = parameters;

load results_SmallJakStat_hierarchical_normal
phn = parameters;
load merged_profiles_SmallJakStat_hierarchical_laplace
phl = parameters;

options.MS.mode = 'silent';
psn = getParameterConfidenceIntervals(psn, 0.95,options.MS);
psl = getParameterConfidenceIntervals(psl, 0.95,options.MS);
phn = getParameterConfidenceIntervals(phn, 0.95,options.MS);
phl = getParameterConfidenceIntervals(phl, 0.95,options.MS);

namesForTable = {'$p_1$','$p_2$','$p_3$','$p_4$','$sp_1$','$sp_2$','$sp_3$','$sp_4$',...
    '$sp_5$', '$\mathrm{offset}_\mathrm{tSTAT}$','$\mathrm{offset}_\mathrm{pSTAT}$' };

for i = 1:phn.number
    disp([namesForTable{i} ' & ' num2str(psn.MS.par(i,1),3) ' & ' num2str(phn.MS.par(i,1),3) ' & '...
        '[' num2str(psn.CI.PL(i,1),3) ',' num2str(psn.CI.PL(i,2),3) ...
        '] & ['  num2str(phn.CI.PL(i,1),3) ',' num2str(phn.CI.PL(i,2),3) '] & ' ... 
        num2str(psl.MS.par(i,1),3) ' & ' num2str(phl.MS.par(i,1),3) ...
        '& [' num2str(psl.CI.PL(i,1),3) ',' num2str(psl.CI.PL(i,2),3) ...
        '] & ['  num2str(phl.CI.PL(i,1),3) ',' num2str(phl.CI.PL(i,2),3) '] & ' ... 
        ' \\'])
end
