clear all
close all
clc

names = {'p_1','p_2','p_3','p_4','sp_1','sp_2','sp_3','sp_4','sp_5',...
            'offset_{tSTAT}','offset_{pSTAT}'};
  
load_colors_hierarchical

load results_trace_SmallJakStat_hierarchical_normal
ph = parameters;

load results_trace_SmallJakStat_standard_normal
ps = parameters;

subplot('Position',[0.1,0.1,0.6,0.55])
colorsparam = hsv(11);
idx = find(isnan(ph.MS.fval_trace));
for i = 1:11
    plot(1:size(ps.MS.par_trace,2),ps.MS.par_trace(i,:),'Color',colorsparam(i,:)); hold on;
    plot(1:size(ph.MS.par_trace,2),ph.MS.par_trace(i,:),'--','Color',colorsparam(i,:)); hold on;
    plot(idx,ph.MS.par_trace(i,find(isnan(ph.MS.fval_trace),1,'first')-1)*ones(numel(idx),1)...
        ,':','Color',colorsparam(i,:)); hold on;
end
set(gca,'tickdir','out','fontsize',setLay.ax.size)
ylabel('log_{10}(\theta)','fontsize',setLay.ax.size)
xlabel('optimization step','fontsize',setLay.ax.size)
xlim([1,ps.MS.n_iter+1])
%legend(names,'fontsize',setLay.ax.size)
box off
subplot('Position',[0.1,0.7,0.6,0.25])
plot(ps.MS.fval_trace,'Color',colors.s.normal); hold on;
plot(ph.MS.fval_trace,'--','Color',colors.h.normal); hold on;
plot(idx,ph.MS.fval_trace(find(isnan(ph.MS.fval_trace),1,'first')-1)*ones(numel(idx),1)...
    ,':','Color',colors.h.normal); hold on;

ylim([-80,65])
ylabel('negative log-likelihood','fontsize',setLay.ax.size)
box off
set(gca,'xticklabel','','tickdir','out','fontsize',setLay.ax.size)
xlim([0,ps.MS.n_iter+1])


set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 18 8])
print('-depsc','../figures/optimizationPath')
