function parameters = runEstimation_ConversionReaction_optimizationPath(varargin)
% runEstimation_ConversionReaction() runs the parameter estimation for the
% conversion reaction example.
%
% USAGE:
% * parameters = runEstimation_ConversionReaction('hierarchical','normal')
%
% Parameters
%  approach: 'hierarchical' or 'standard' approach for the optimization
%  distribution: 'normal' (Gaussian noise) or 'laplace' (Laplace noise) for
%  the noise distribution
%
% Return values:
% parameters: returned by getMultiStarts

approach = varargin{1};
distribution = varargin{2};


load('data/data_ConversionReaction.mat')
[parameters,options] = getParameterOptions_ConversionReaction(approach);

options.MS.HO.distribution = distribution;
options.MS.save = false;
if ~exist('results','dir')
    mkdir('results')
end
options.MS.foldername = ['./results/results_ConversionReaction_' approach '_' distribution '_optimizationPath'];
options.MS.n_starts = 1;
parameters.guess = parameters.guess(:,13);
options.MS.trace = true;

parameters = getMultiStarts(parameters,@(xi) ...
    logLikelihood_ConversionReaction(xi,D,options,approach),options.MS);

save(options.MS.foldername,'parameters','D','options','approach')

end