function [model] = ConversionReaction_syms()

model.param = 'log10'; 

%% STATES

% create state syms
syms x1 x2

% create state vector
x = [
x1 x2
];

%% PARAMETERS ( for these sensitivities will be computed )

% create parameter syms
syms p1 p2

% create parameter vector 
p = [p1,p2];


%% SYSTEM EQUATIONS

% create symbolic variable for time
syms t

xdot = sym(zeros(size(x)));

xdot(1) = -p1*x1+p2*x2;
xdot(2) = +p1*x1-p2*x2 ;


%% INITIAL CONDITIONS

x0 = sym(zeros(size(x)));

x0(1) = 1;
x0(2) = 0;


%% OBSERVABLES

y = sym(zeros(1,1));

y(1) = x2;

%% SYSTEM STRUCT

model.sym.x = x;
model.sym.k = [];
model.sym.xdot = xdot;
model.sym.p = p;
model.sym.x0 = x0;
model.sym.y = y;
end