% Main file of the conversion reaction example.
%
% Demonstrates the use of:
% * logLikelhoodHierarchical()
%
% Performs parameter estimation for the standard and hierarchical approach
% and Gaussian and Laplace noise.

clear all 
close all
clc

%% Compilation of simulation files using AMICI
addpath('models/')
compilation_ConversionReaction

%% Optimization using 
runEstimation_ConversionReaction('hierarchical','normal')
runEstimation_ConversionReaction('hierarchical','laplace')

runEstimation_ConversionReaction('standard','normal')
runEstimation_ConversionReaction('standard','laplace')

%%
runEstimation_ConversionReaction_optimizationPath('hierarchical','normal')
runEstimation_ConversionReaction_optimizationPath('standard','normal')
