function [] = visualize_histones_fitsForPaper(foldername, domainModelFile, varargin)
% This function visualizes model fits of the global model, the global
% model without K27 demethylation, and the model in the file
% domainModelFile.

if nargin > 2
    figurename = varargin{1};
    saveFigures = varargin{2};
else
    saveFigures = false;
end
%%
load_plot_settings
if labelFlag 
    opts.plot.title = true;
end
opts.plot.errorbars = 1;
opts.plot.errorbarwidth = 1;
opts.plot.lw = 0.5;
opts.plot.samefigure = 1;
opts.plot.legendflag = 0;
opts.plot.tsim = linspace(0.1,24+3);
opts.plot.A.markersize = 6.5;
opts.plot.pos_flag = true;
positions = load_positions();
opts.plot.positions = positions;

load([foldername '/findOffset/results_globalDemeth_CAL311_319_all_WT_offset1em1'],'DA')
load(domainModelFile)
xi = parameters.MS.par(:,1);
ll = logLikelihood_histones_hierarchical(xi,DA,simulateA,options);
try
    ll = logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options);
catch
end
if abs(ll-parameters.MS.logPost(1)) > 1e-2
    error('not reproducible')
end
opts.llh.n_theta = options.llh.n_theta;
opts.llh.input = options.llh.input;
opts.ami = options.ami;
opts.plot.model.lw = 0.8;
opts.plot.A.color.model = color.domains;
opts.plot.A.ls = '-';
fh=plot_histones(xi,DA,simulateA,opts);
opts.plot.fh = fh;
opts.plot.holdon = true;
n_data = sum(sum(sum(~isnan(DA.my))));
BIC_domain = -2*parameters.MS.logPost(1) + ...
    log(n_data)*(parameters.number-length(options.MS.fixedParameters)); % not + 1 because of relative size

load([foldername '/findOffset/results_globalDemeth_CAL311_319_all_WT_offset1em1'])
xi = parameters.MS.par(:,1);
ll = logLikelihood_histones_hierarchical(xi,DA,simulateA,options);
try
    ll = logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options);
catch
end
if abs(ll-parameters.MS.logPost(1)) > 1e-2
    error('not reproducible')
end
opts.plot.A.color.model = color.global;
opts.llh.n_theta = options.llh.n_theta;
opts.llh.input = options.llh.input;
opts.plot.A.ls = '--';
opts.plot.model.lw = 1;
opts.ami = options.ami;
fh = plot_histones(xi,DA,simulateA,opts);

BIC_global = -2*parameters.MS.logPost(1) + ...
    log(n_data)*(parameters.number-length(options.MS.fixedParameters)+1);

figure(fh{1})
fh{1}.Name = 'generation 1';
for s = 1:15
    subplot('Position',opts.plot.positions{s})
    ylim([0,35]);
    set(gca,'TickDir','out')
    if s <= 4
        ylim([0,30]);
    elseif s > 4 && s <= 8
        ylim([0,12]);
    elseif s > 8 && s <= 12
        ylim([0,35]);
    else
        ylim([0,25]);
    end
    xlim([-1,28])
    if ismember(s, [2,3,4,6,7,8,10,11,12,14,15])
        set(gca,'yticklabel','');
    end
end

set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_FigS2C_gen1_' figurename])
end
figure(fh{2})
fh{2}.Name = 'generation 2';
for s = 1:15
    subplot('Position',opts.plot.positions{s})
    set(gca,'TickDir','out')
    if s <= 4
        ylim([0,70]);
    elseif s > 4 && s <= 8
        ylim([0,30]);
    elseif s > 8 && s <= 12
        ylim([0,60]);
    else
        ylim([0,25]);
    end
    xlim([-1,28])
    if ismember(s, [2,3,4,6,7,8,10,11,12,14,15])
        set(gca,'yticklabel','');
    end
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_FigS2C_gen2_'  figurename])
end
figure(fh{3})
fh{3}.Name = 'generation 3';
for s = 1:15
    subplot('Position',opts.plot.positions{s})
    set(gca,'TickDir','out')
    if s <= 4
        ylim([0,50]);
    elseif s > 4 && s <= 8
        ylim([0,40]);
    elseif s > 8 && s <= 12
        ylim([0,40]);
    else
        ylim([0,10]);
    end
    xlim([-1,28])
    if ismember(s, [2,3,4,6,7,8,10,11,12,14,15]     )
        set(gca,'yticklabel','');
    end
end
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_FigS2C_gen3_' figurename])
end

%% only K27me3K36me0
opts.plot.errorbars = 1;
opts.plot.errorbarwidth = 1;
opts.plot.lw = 0.5;
opts.plot.samefigure = 1;
opts.plot.legendflag = 0;
opts.plot.tsim = linspace(0.1,24+3);
opts.plot.A.markersize = 6.5;
opts.plot.pos_flag = true;
positions{1} = [0.2,0.2,0.7,0.7];
opts.plot.positions = positions;
opts.plot.observables = 13;

% Domain model
load(domainModelFile)
xi = parameters.MS.par(:,1);
opts.plot.model.lw = 0.8;
opts.plot.A.color.model = color.domains;
opts.plot.A.ls = '-';
opts.llh.n_theta = options.llh.n_theta;
opts.llh.input = options.llh.input;
opts.ami = options.ami;
opts.plot.fh = [];
fh_30 = plot_histones(xi,DA,simulateA,opts);
opts.plot.fh = fh_30;
opts.plot.holdon = true;

% global model
load([foldername '/findOffset/results_globalDemeth_CAL311_319_all_WT_offset1em1'])
xi = parameters.MS.par(:,1);
opts.plot.A.color.model = color.global;
opts.llh.n_theta = options.llh.n_theta;
opts.llh.input = options.llh.input;
opts.plot.A.ls = '---';
opts.plot.model.lw = 1;
opts.ami = options.ami;
fh=plot_histones(xi,DA,simulateA,opts);

figure(fh_30{1})
fh_30{1}.Name = 'generation 1, K27me3K36me0';
ylim([0,25])
xlim([-1,28])
if labelFlag
    ylabel('rel. abundance')
    xlabel('time [hr]')
end
set(gca,'TickDir','out')
set(gca,'xtick',[DA.t],'xticklabel',{'-3','0','','8','16','24'},'FontSize',fs);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 4 3])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_Fig2C_gen1_' figurename])
end
figure(fh_30{2})
fh_30{2}.Name = 'generation 2, K27me3K36me0';
xlim([-1,28])
ylim([0,25])
if labelFlag
    ylabel('rel. abundance')
    xlabel('time [hr]')
end
set(gca,'TickDir','out')
set(gca,'xtick',[DA.t],'xticklabel',{'-3','0','','8','16','24'},'FontSize',fs);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 4 3])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_Fig2C_gen2_' figurename])
end
figure(fh_30{3})
fh_30{3}.Name = 'generation 3, K27me3K36me0';
set(gca,'TickDir','out')
xlim([-1,28])
ylim([0,25])
if labelFlag
    ylabel('rel. abundance')
    xlabel('time [hr]')
end
set(gca,'xtick',[DA.t],'xticklabel',{'-3','0','','8','16','24'},'FontSize',fs);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 4 3])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_Fig2C_gen3_' figurename])
end

%% No demethylation only K27me3K36me0
opts.plot.lw = 0.5;
opts.plot.generations = 1;
positions{1} = [0.2,0.2,0.35,0.7];
positions{2} = [0.6,0.2,0.35,0.7];
opts.plot.positions = positions;
opts.plot.observables = 13:14;

load([foldername '/results_globalDemeth_noK27demeth'])
xi = parameters.MS.par(:,1);
ll = logLikelihood_histones_hierarchical(xi,DA,simulateA,options);
try
    ll = logLikelihood_histones_hierarchical(xi,DA,DB,simulateA,simulateB,options);
catch
end
if abs(ll-parameters.MS.logPost(1)) > 1e-2
    error('not reproducible')
end
opts.plot.A.ls = '-';
opts.plot.model.lw = 1;
opts.plot.A.color.model = color.noK27;
opts.llh.n_theta = options.llh.n_theta;
opts.llh.input = options.llh.input;
opts.ami = options.ami;
opts.plot.fh = [];
fh_nodem=plot_histones(xi,DA,simulateA,opts);
opts.plot.fh = fh_nodem;
opts.plot.holdon = true;

load(domainModelFile)
opts.plot.A.color.model = color.domains;
opts.plot.A.ls = '-';
opts.plot.model.lw = 0.9;
xi = parameters.MS.par(:,1);
opts.llh.n_theta = options.llh.n_theta;
opts.llh.input = options.llh.input;
opts.ami = options.ami;
fh_nodem=plot_histones(xi,DA,simulateA,opts);

load([foldername '/findOffset/results_globalDemeth_CAL311_319_all_WT_offset1em1'])
xi = parameters.MS.par(:,1);
opts.plot.A.color.model = color.global;
opts.plot.A.ls = '--';
opts.plot.model.lw = 1;
opts.llh.n_theta = options.llh.n_theta;
opts.llh.input = options.llh.input;
opts.ami = options.ami;
fh_nodem=plot_histones(xi,DA,simulateA,opts);


figure(fh_nodem{1})
fh_nodem{1}.Name = 'no demethylation';
subplot('Position',positions{1});
if labelFlag
    ylabel('rel. abundance')
    xlabel('time [hr]')
end
ylim([0,25])
xlim([-1,28])
set(gca,'TickDir','out','fontsize',fs)
set(gca,'xtick',[DA.t],'xticklabel',{'','0','','8','16','24'},'FontSize',fs);
subplot('Position',positions{2});
if labelFlag
    xlabel('time [hr]')
end
ylim([0,25])
xlim([-1,28])
set(gca,'TickDir','out','yticklabel','','fontsize',fs)
set(gca,'xtick',[DA.t],'xticklabel',{'','0','','8','16','24'},'FontSize',fs);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 7 3])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_FigS2D_gen1_' figurename])
end
