function fh = visualize_flux_domainModel(parameters,flux)
% This function visualizes the fluxes for the domain model. Thickness of
% line corresponds to size of flux.

load_plot_settings
fh = figure;

for iRate = 1:22 
    yMod = [str2num(parameters.name{iRate}(2)),str2num(parameters.name{iRate}(5))]; % K27: from to
    xMod =  [str2num(parameters.name{iRate}(3)),str2num(parameters.name{iRate}(6))]; % K36: from to
    
    plot(xMod,-yMod,'LineWidth',flux(iRate)*3.5+0.1,'Color',[0,0,0]); hold on;
    if xMod(2) > xMod(1)
        text(xMod(1)+0.32,-yMod(1)-0.15,num2str(flux(iRate),2),'FontSize',fs);
    else
        text(xMod(1)+0.1,-yMod(1)-0.5,num2str(flux(iRate),2),'FontSize',fs);
    end
%     if xMod(2) > xMod(1)
%         text(xMod(1)+0.32,-yMod(1)-0.15,[num2str(flux(iRate),2),'%'],'FontSize',fs);
%     else
%         text(xMod(1)+0.1,-yMod(1)-0.5,[num2str(flux(iRate),2),'%'],'FontSize',fs);
%     end
end

box off
axis off
axis square
