function [sol_all] = simulate_histones_all_withpreequ_inhibitor(t,xiA,xiB,...
    kappa,options,sim_light,sim_all)

preequ_flag = true;
tsim = 1e3;

% preequlibration of light histones
while preequ_flag && tsim < 1e7
    sol_light = sim_light(tsim,xiA,kappa,options);
    if abs(max(sol_light.diagnosis.xdot)) > 1e-3
        tsim = 2*tsim;
        options.x0 = sol_light.x;
    else
        preequ_flag = false;
    end
end

if preequ_flag
    error('no steady state found')
end

% check
options.x0 = [sol_light.x';zeros(length(sol_light.x)*2,1)];

% simulate all
sol_all = sim_all(t,xiB,kappa,options);

end
