function sol_all = simulate_histones_all_withpreequ(t,xi,kappa,options,sim_light,sim_all)
% This function preequilibrates the light (generation 1) histones and then 
% initializes and simulates all generations. This is separated because of
% computation time, which is substantially reduced when performing the
% preequlibration only with the reduced model

preequ_flag = true;
tsim = 1e3;
% preequlibration of light histones
while preequ_flag && tsim < 1e7
    sol_light = sim_light(tsim,xi,kappa,options);
    % check whether system is in steady state (according to threshold)
    if abs(max(sol_light.diagnosis.xdot)) > 1e-3 
        tsim = 2*tsim; % double simulation time
        options.x0 = sol_light.x;
        if options.sensi
            options.sx0 = sol_light.sx;
        end
    else
        preequ_flag = false;
    end
end

if preequ_flag
    error('no steady state found')
end
 
% initialize initial values for furhter simulation
options.x0 = [sol_light.x';zeros(2*length(sol_light.x),1)];
n_theta = size(squeeze(sol_light.sx),2);

if options.sensi
    options.sx0 = [squeeze(sol_light.sx);zeros(2*length(sol_light.x),n_theta)];
end

% simulate all
sol_all = sim_all(t,xi,kappa,options);

end