
function model = histones_standardDemeth_light_preequ_syms()

syms t
model.param = 'log10';

% STATES
syms l00 l01 l02 l03 l10 l11 l12 l13 l20 l21 l22 l23 l30 l31 l32 offset

model.sym.x = [l00, l01, l02, l03, l10, l11, l12, l13, l20, l21, l22, l23, l30, l31, l32];
 
% PARAMETERS

syms  d   d27_1 d27_2 d27_3    d36_1 d36_2 d36_3   r00_01    r00_10    r01_02    r01_11    r02_03    r02_12
syms     r03_13    r10_11    r10_20    r11_12    r11_21    r12_13    r12_22    r13_23    r20_21    r20_30
syms     r21_22    r21_31    r22_23    r22_32    r30_31    r31_32      

ind_light = 1:15;

model.sym.p = [d,d27_1,d27_2,d27_3,d36_1,d36_2,d36_3,r00_01,r00_10,r01_02,r01_11,r02_03,r02_12,...
     r03_13,r10_11,r10_20,r11_12,r11_21,r12_13,r12_22,r13_23,r20_21,r20_30,...
     r21_22,r21_31,r22_23,r22_32,r30_31,r31_32];

model.sym.xdot(ind_light) = [...
    d - d*l00 + d27_1*l10 + d36_1*l01 - l00*r00_10 - l00*r00_01,...
    d27_1*l11 - d36_1*l01 - d*l01 + d36_2*l02 + l00*r00_01 - l01*r01_11 - l01*r01_02,...
    d27_1*l12 - d36_2*l02 - d*l02 + d36_3*l03 + l01*r01_02 - l02*r02_12 - l02*r02_03,...
    d27_1*l13 - d36_3*l03 - d*l03 + l02*r02_03 - l03*r03_13,...
    d27_2*l20 - d27_1*l10 - d*l10 + d36_1*l11 + l00*r00_10 - l10*r10_20 - l10*r10_11,...
    d27_2*l21 - d27_1*l11 - d36_1*l11 - d*l11 + d36_2*l12 + l01*r01_11 + l10*r10_11 - l11*r11_21 - l11*r11_12,...
    d27_2*l22 - d27_1*l12 - d36_2*l12 - d*l12 + d36_3*l13 + l02*r02_12 + l11*r11_12 - l12*r12_22 - l12*r12_13,...
    d27_2*l23 - d27_1*l13 - d36_3*l13 - d*l13 + l03*r03_13 + l12*r12_13 - l13*r13_23,...
    d27_3*l30 - d27_2*l20 - d*l20 + d36_1*l21 + l10*r10_20 - l20*r20_30 - l20*r20_21,...
    d27_3*l31 - d27_2*l21 - d36_1*l21 - d*l21 + d36_2*l22 + l11*r11_21 + l20*r20_21 - l21*r21_31 - l21*r21_22,...
    d27_3*l32 - d27_2*l22 - d36_2*l22 - d*l22 + d36_3*l23 + l12*r12_22 + l21*r21_22 - l22*r22_32 - l22*r22_23,...
    - d27_2*l23 - d36_3*l23 - d*l23 + l13*r13_23 + l22*r22_23,...
    d36_1*l31 - d27_3*l30 - d*l30 + l20*r20_30 - l30*r30_31,...
    d36_2*l32 - d27_3*l31 - d36_1*l31 - d*l31 + l21*r21_31 + l30*r30_31 - l31*r31_32,...
    - d27_3*l32 - d36_2*l32 - d*l32 + l22*r22_32 + l31*r31_32];

model.sym.x0 = [sym(1),sym(zeros(1,14))];

model.sym.k = [offset];

% relative
model.sym.y(ind_light) = log([l00 ,...
    l01 ,...
    l02 ,...
    l03 ,...
    l10 ,...
    l11 ,...
    l12 ,...
    l13 ,...
    l20 ,...
    l21 ,...
    l22 ,...
    l23 ,...
    l30 ,...
    l31 ,...
    l32 ]./(l00+l01+l02+l03+l10+l12+l20+l21+l23+l11+l30+l32+l31+l22+l13) + offset);


