function model = histones_standardDemeth_all_syms()

syms t
model.param = 'log10';

% STATES
syms m00 m01 m02 m03 m10 m11 m12 m13 m20 m21 m22 m23 m30 m31 m32 offset
syms l00 l01 l02 l03 l10 l11 l12 l13 l20 l21 l22 l23 l30 l31 l32
syms h00 h01 h02 h03 h10 h11 h12 h13 h20 h21 h22 h23 h30 h31 h32

model.sym.x = [l00, l01, l02, l03, l10, l11, l12, l13, l20, l21, l22, l23, l30, l31, l32,...
    m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32,...
    h00, h01, h02, h03, h10, h11, h12, h13, h20, h21, h22, h23, h30, h31, h32];

% PARAMETERS

syms  d  d27_1  d27_2 d27_3 d36_1  d36_2  d36_3   r00_01    r00_10    r01_02    r01_11    r02_03    r02_12
syms     r03_13    r10_11    r10_20    r11_12    r11_21    r12_13    r12_22    r13_23    r20_21    r20_30
syms     r21_22    r21_31    r22_23    r22_32    r30_31    r31_32

ind_light = 1:15;
ind_medium = 16:30;
ind_heavy = 31:45;

model.sym.p = [d,d27_1,d27_2,d27_3,d36_1,d36_2,d36_3,r00_01,r00_10,r01_02,r01_11,r02_03,r02_12,...
    r03_13,r10_11,r10_20,r11_12,r11_21,r12_13,r12_22,r13_23,r20_21,r20_30,...
    r21_22,r21_31,r22_23,r22_32,r30_31,r31_32];

model.sym.xdot(ind_light) = [...
    d27_1*l10 + d36_1*l01 - l00*r00_10 - l00*r00_01,...
    d27_1*l11 - d36_1*l01 + d36_2*l02 + l00*r00_01 - l01*r01_11 - l01*r01_02,...
    d27_1*l12 - d36_2*l02 + d36_3*l03 + l01*r01_02 - l02*r02_12 - l02*r02_03,...
    d27_1*l13 - d36_3*l03 + l02*r02_03 - l03*r03_13,...
    d27_2*l20 - d27_1*l10 + d36_1*l11 + l00*r00_10 - l10*r10_20 - l10*r10_11,...
    d27_2*l21 - d27_1*l11 - d36_1*l11 + d36_2*l12 + l01*r01_11 + l10*r10_11 - l11*r11_21 - l11*r11_12,...
    d27_2*l22 - d27_1*l12 - d36_2*l12 + d36_3*l13 + l02*r02_12 + l11*r11_12 - l12*r12_22 - l12*r12_13,...
    d27_2*l23 - d27_1*l13 - d36_3*l13 + l03*r03_13 + l12*r12_13 - l13*r13_23,...
    d27_3*l30 - d27_2*l20 + d36_1*l21 + l10*r10_20 - l20*r20_30 - l20*r20_21,...
    d27_3*l31 - d27_2*l21 - d36_1*l21 + d36_2*l22 + l11*r11_21 + l20*r20_21 - l21*r21_31 - l21*r21_22,...
    d27_3*l32 - d27_2*l22 - d36_2*l22 + d36_3*l23 + l12*r12_22 + l21*r21_22 - l22*r22_32 - l22*r22_23,...
    - d27_2*l23 - d36_3*l23 + l13*r13_23 + l22*r22_23,...
    d36_1*l31 - d27_3*l30 + l20*r20_30 - l30*r30_31,...
    d36_2*l32 - d27_3*l31 - d36_1*l31+ l21*r21_31 + l30*r30_31 - l31*r31_32,...
    - d27_3*l32 - d36_2*l32 + l22*r22_32 + l31*r31_32];


model.sym.xdot(ind_medium) = [...
    d*(1-heaviside(t-3)) - d*(1-heaviside(t-3))*m00 + d27_1*m10 + d36_1*m01 - m00*r00_10 - m00*r00_01,...%s*(1-presim)*(1-heaviside(t-6)) - d*m00 + d27*m10 + d36*m01 - m00*r00_10 - m00*r00_01,...
    d27_1*m11 - d36_1*m01 - d*(1-heaviside(t-3))*m01 + d36_2*m02 + m00*r00_01 - m01*r01_11 - m01*r01_02,...
    d27_1*m12 - d36_2*m02 - d*(1-heaviside(t-3))*m02 + d36_3*m03 + m01*r01_02 - m02*r02_12 - m02*r02_03,...
    d27_1*m13 - d36_3*m03 - d*(1-heaviside(t-3))*m03 + m02*r02_03 - m03*r03_13,...
    d27_2*m20 - d27_1*m10 - d*(1-heaviside(t-3))*m10 + d36_1*m11 + m00*r00_10 - m10*r10_20 - m10*r10_11,...
    d27_2*m21 - d27_1*m11 - d36_1*m11 - d*(1-heaviside(t-3))*m11 + d36_2*m12 + m01*r01_11 + m10*r10_11 - m11*r11_21 - m11*r11_12,...
    d27_2*m22 - d27_1*m12 - d36_2*m12 - d*(1-heaviside(t-3))*m12 + d36_3*m13 + m02*r02_12 + m11*r11_12 - m12*r12_22 - m12*r12_13,...
    d27_2*m23 - d27_1*m13 - d36_3*m13 - d*(1-heaviside(t-3))*m13 + m03*r03_13 + m12*r12_13 - m13*r13_23,...
    d27_3*m30 - d27_2*m20 - d*(1-heaviside(t-3))*m20 + d36_1*m21 + m10*r10_20 - m20*r20_30 - m20*r20_21,...
    d27_3*m31 - d27_2*m21 - d36_1*m21 - d*(1-heaviside(t-3))*m21 + d36_2*m22 + m11*r11_21 + m20*r20_21 - m21*r21_31 - m21*r21_22,...
    d27_3*m32 - d27_2*m22 - d36_2*m22 - d*(1-heaviside(t-3))*m22 + d36_3*m23 + m12*r12_22 + m21*r21_22 - m22*r22_32 - m22*r22_23,...
    - d27_2*m23 - d36_3*m23 - d*(1-heaviside(t-3))*m23 + m13*r13_23 + m22*r22_23,...
    d36_1*m31 - d27_3*m30 - d*(1-heaviside(t-3))*m30 + m20*r20_30 - m30*r30_31,...
    d36_2*m32 - d27_3*m31 - d36_1*m31 - d*(1-heaviside(t-3))*m31 + m21*r21_31 + m30*r30_31 - m31*r31_32,...
    - d27_3*m32 - d36_2*m32 - d*(1-heaviside(t-3))*m32 + m22*r22_32 + m31*r31_32];

model.sym.xdot(ind_heavy) = [...
    d*(heaviside(t-3)) - d*(heaviside(t-3))*h00 + d27_1*h10 + d36_1*h01 - h00*r00_10 - h00*r00_01,...%s*(1-presih)*(1-heaviside(t-6)) - d*h00 + d27*h10 + d36*h01 - h00*r00_10 - h00*r00_01,...
    d27_1*h11 - d36_1*h01 - d*(heaviside(t-3))*h01 + d36_2*h02 + h00*r00_01 - h01*r01_11 - h01*r01_02,...
    d27_1*h12 - d36_2*h02 - d*(heaviside(t-3))*h02 + d36_3*h03 + h01*r01_02 - h02*r02_12 - h02*r02_03,...
    d27_1*h13 - d36_3*h03 - d*(heaviside(t-3))*h03 + h02*r02_03 - h03*r03_13,...
    d27_2*h20 - d27_1*h10 - d*(heaviside(t-3))*h10 + d36_1*h11 + h00*r00_10 - h10*r10_20 - h10*r10_11,...
    d27_2*h21 - d27_1*h11 - d36_1*h11 - d*(heaviside(t-3))*h11 + d36_2*h12 + h01*r01_11 + h10*r10_11 - h11*r11_21 - h11*r11_12,...
    d27_2*h22 - d27_1*h12 - d36_2*h12 - d*(heaviside(t-3))*h12 + d36_3*h13 + h02*r02_12 + h11*r11_12 - h12*r12_22 - h12*r12_13,...
    d27_2*h23 - d27_1*h13 - d36_3*h13 - d*(heaviside(t-3))*h13 + h03*r03_13 + h12*r12_13 - h13*r13_23,...
    d27_3*h30 - d27_2*h20 - d*(heaviside(t-3))*h20 + d36_1*h21 + h10*r10_20 - h20*r20_30 - h20*r20_21,...
    d27_3*h31 - d27_2*h21 - d36_1*h21 - d*(heaviside(t-3))*h21 + d36_2*h22 + h11*r11_21 + h20*r20_21 - h21*r21_31 - h21*r21_22,...
    d27_3*h32 - d27_2*h22 - d36_2*h22 - d*(heaviside(t-3))*h22 + d36_3*h23 + h12*r12_22 + h21*r21_22 - h22*r22_32 - h22*r22_23,...
    - d27_2*h23 - d36_3*h23 - d*(heaviside(t-3))*h23 + h13*r13_23 + h22*r22_23,...
    d36_1*h31 - d27_3*h30 - d*(heaviside(t-3))*h30 + h20*r20_30 - h30*r30_31,...
    d36_2*h32 - d27_3*h31 - d36_1*h31 - d*(heaviside(t-3))*h31 + h21*r21_31 + h30*r30_31 - h31*r31_32,...
    - d27_3*h32 - d36_2*h32 - d*(heaviside(t-3))*h32 + h22*r22_32 + h31*r31_32];

model.sym.x0 = [sym(zeros(1,45))];
model.sym.k = [offset];

% OBSERVABLES

% relative
model.sym.y(ind_light) = log([l00 ,...
    l01 ,...
    l02 ,...
    l03 ,...
    l10 ,...
    l11 ,...
    l12 ,...
    l13 ,...
    l20 ,...
    l21 ,...
    l22 ,...
    l23 ,...
    l30 ,...
    l31 ,...
    l32 ]./(l00+l01+l02+l03+l10+l12+l20+l21+l23+l11+l30+l32+l31+l22+l13) + offset);

model.sym.y(ind_medium) = log([m00 ,...
    m01 ,...
    m02 ,...
    m03 ,...
    m10 ,...
    m11 ,...
    m12 ,...
    m13 ,...
    m20 ,...
    m21 ,...
    m22 ,...
    m23 ,...
    m30 ,...
    m31 ,...
    m32 ]./(m00+m01+m02+m03+m10+m12+m20+m21+m23+m11+m30+m32+m31+m22+m13) + offset);

model.sym.y(ind_heavy) = log([h00 ,...
    h01 ,...
    h02 ,...
    h03 ,...
    h10 ,...
    h11 ,...
    h12 ,...
    h13 ,...
    h20 ,...
    h21 ,...
    h22 ,...
    h23 ,...
    h30 ,...
    h31 ,...
    h32 ]./(h00+h01+h02+h03+h10+h12+h20+h21+h23+h11+h30+h32+h31+h22+h13) +offset);

model.sym.sigma_y = sym(ones(45,1));

