% This script automatically generates the syms file for the model with
% defined domains for all the culture media, light medium and heavy
function [] = generate_domainModel(domains,modelname,culturemedium)

turnoverflag = false;

%domains = {'00','01','02','03','10','11','12','13','20','21','22','23','30','31','32'};

% l: light, m: medium, h: heavy
%culturemedium = {'l','m','h'};

combstr = {'00','01','02','03','10','11','12','13','20','21','22','23','30','31','32'};

% Parameters
ratestr = {'r00_01','r00_10','r01_02','r01_11','r02_03','r02_12','r03_13',...
    'r10_11','r10_20','r11_12','r11_21',...
    'r12_13','r12_22','r13_23','r20_21','r20_30','r21_22','r21_31',...
    'r22_23','r22_32','r30_31','r31_32'};

%% Generate strings for each of the states of a culture midum, first two
% numbers indicate modification, second to the final modification it ends up
count = 1;
for i = 1:15
    for j = 1:length(domains)
        reg = [str2num(domains{j}(1)),str2num(domains{j}(2))];
        state = [str2num(combstr{i}(1)),str2num(combstr{i}(2))];
        if reg(1) >= state(1) && reg(2) >= state(2)
            statesstr{count}=[combstr{i} '_' domains{j}];
            count = count+1;
        end
    end
end

fid = fopen(['./generatedSimulations/histones_' modelname '_syms.m'],'w');

str = ['function [model] = histones_' modelname '_syms() \n\n'];
str = [str 'model.param = ''log10'';\n\n']; % not required?

%% define states for each of the culture media
str = strcat(str, 'syms');
for c = 1:length(culturemedium)
    for i = 1:15
        for j = 1:length(domains)
            reg = [str2num(domains{j}(1)),str2num(domains{j}(2))];
            state = [str2num(combstr{i}(1)),str2num(combstr{i}(2))];
            if reg(1) >= state(1) && reg(2) >= state(2)
                str = strcat([str ' ' culturemedium{c}(1) '' combstr{i} '_' domains{j} ' ']);
            end
        end
    end
end

str = [str '\nsyms t offset\n\n'];

%% define indices for states (x) and observables (y) for each culture medium
% (l m h)
str = [str 'ind_x' culturemedium{1}(1) ' = [1:' num2str(length(statesstr)) '];\n'];
if length(culturemedium) > 1
    str = [str 'ind_x' culturemedium{2}(1) ' = [' num2str(length(statesstr)+1) ':' num2str(2*length(statesstr)) '];\n'];
end
if length(culturemedium) > 2
    str = [str 'ind_x' culturemedium{3}(1) ' = [' num2str(2*length(statesstr)+1) ':' num2str(3*length(statesstr)) '];\n'];
end
str = [str 'ind_y' culturemedium{1}(1) ' = [1:15];\n'];
if length(culturemedium) > 1
    str = [str 'ind_y' culturemedium{2}(1) ' = [16:30];\n'];
end
if length(culturemedium) > 2
    str = [str 'ind_y' culturemedium{3}(1) ' = [31:45];\n'];
end

%% Write parameters, methylation rates (r), cell cycle (c) and domains (w)
str = strcat(str, '\nsyms');

for i = 1:numel(ratestr)
    str = strcat([str ' ' ratestr{i}]);
end
str = strcat(str, ' c');
if turnoverflag
    str = strcat(str, ' turnover');
end
for i = 1:length(domains)
    str = [str ' w' domains{i}];
end

str = [str '\n\nmodel.sym.p = ['];
for i = 1:numel(ratestr)
    str = strcat([str '' ratestr{i} ';']);
end

str = [str 'c;'];
if turnoverflag
    str = [str 'turnover;'];
end
for i = 1:length(domains)
    str = [str ' w' domains{i} ';'];
end
str = [str '];\n\n'];

%% Write states for each culture medium
for c = 1:length(culturemedium) % culture medium
    str = [str 'model.sym.x(ind_x' culturemedium{c}(1) ') = ['];
    for i = 1:15 % modification
        for j = 1:length(domains)
            reg = [str2num(domains{j}(1)),str2num(domains{j}(2))];
            state = [str2num(combstr{i}(1)),str2num(combstr{i}(2))];
            if reg(1) >= state(1) && reg(2) >= state(2)
                if i == 1 && j == 1
                    str = strcat([str '' culturemedium{c}(1) '' combstr{i} '_' domains{j}]);
                else
                    str = strcat([str ' ;\n' culturemedium{c}(1) '' combstr{i} '_' domains{j}]);
                end
            end
        end
    end
    str = strcat([str '];\n']);
end

%% Define ODE for each of the states
for c = 1:length(culturemedium)
    str = [str '\n\nmodel.sym.xdot(ind_x' culturemedium{c}(1) ') = ['];
    for count = 1:numel(statesstr)
        reg = [str2num(statesstr{count}(end-1)),str2num(statesstr{count}(end))];
        state = [str2num(statesstr{count}(1)),str2num(statesstr{count}(2))];
        
        %if x00 increase by cell cycle, depending on culture medium,
        %culture medium medium is used for 3 hours
        switch culturemedium{c}
            case 'l_preequ'
                if state(1) == 0 && state(2) == 0
                    str = [str 'c'];
                end
            case 'l'
                if state(1) == 0 && state(2) == 0 && reg(1) == 0 && reg(2) == 0
                    str = [str '0'];
                end
            case 'm'
                if state(1) == 0 && state(2) == 0
                    str = [str 'c*(1-heaviside(t-3))'];
                end
            case 'h'
                if state(1) == 0 && state(2) == 0
                    str = [str 'c*(heaviside(t-3))'];
                end
        end
        if turnoverflag && state(1) == 0 && state(2) == 0
            str = [str '+turnover'];
        end
        
        % increase by K36 methylation
        if state(2) > 0
            str = [str 'r' num2str(state(1)) '' num2str(state(2)-1) '_' num2str(state(1)) '' num2str(state(2)) ...
                '*' culturemedium{c}(1) '' num2str(state(1)) '' num2str(state(2)-1) '_' num2str(reg(1)) '' num2str(reg(2))];
        end
        
        % increase by K27 methylation
        if state(1) > 0
            str = [str '+r' num2str(state(1)-1) '' num2str(state(2)) '_' num2str(state(1)) '' num2str(state(2)) ...
                '*' culturemedium{c}(1) '' num2str(state(1)-1) '' num2str(state(2)) '_' num2str(reg(1)) '' num2str(reg(2))];
        end
        
        % loss by further K36 methylation
        if reg(2) > state(2) && ~(state(1) == 3 && state(2)+1 == 3)
            str = [str '-r' num2str(state(1)) '' num2str(state(2)) '_' num2str(state(1)) '' num2str(state(2)+1) '*' culturemedium{c}(1) '' statesstr{count}];
        end
        
        % loss by further K27 methylation
        if reg(1) > state(1) && ~(state(1)+1 == 3 && state(2) == 3)
            str = [str '-r' num2str(state(1)) '' num2str(state(2)) '_' num2str(state(1)+1) '' num2str(state(2)) '*' culturemedium{c}(1) '' statesstr{count}];
        end
        
        % dilution due to cell cycle
        switch culturemedium{c}
            case 'l_preequ'
                str = [str  '-c*l' statesstr{count}];
            case 'm'
                str = [str  '-c*(1-heaviside(t-3))*m' statesstr{count}];
            case 'h'
                str = [str  '-c*(heaviside(t-3))*h' statesstr{count}];
        end
        if turnoverflag && count == numel(statesstr)
            str = [str  '-turnover*' culturemedium{c}(1) '' statesstr{count} '];'];
        elseif turnoverflag && ~(count==numel(statesstr))
            str = [str  '-turnover*' culturemedium{c}(1) '' statesstr{count} ';\n'];
        elseif ~turnoverflag && count == numel(statesstr)
            str = [str  '];'];
        else
            str = [str  ';\n'];
        end
        count = count+1;
    end
end


%% Define and write observables
for c = 1:length(culturemedium)
    % first line and contribution of proportion ending in 00
    str = [str  '\n\nmodel.sym.y(ind_y' culturemedium{c}(1) ') = log(['];
    for i = 1:15
        flag = true; % if state not present at all, write 0
        for r = 1:length(domains)
            if str2num(combstr{i}(1)) <= str2num(domains{r}(1)) ...
                    && str2num(combstr{i}(2)) <= str2num(domains{r}(2))
                str = [str  '+w' domains{r} '*' culturemedium{c}(1) '' combstr{i} '_' domains{r}];
                flag = false;
            end
        end
        if flag
            str = [str  '0'];
        end
        if i < 15
            str = [str  ',...\n\t'];
        end
    end
    str = [str  ']./('];
    
    % divide by all modifications in each proportion to obtain relative
    % levels
    for i = 1:15
        for r = 1:length(domains)
            if str2num(combstr{i}(1)) <= str2num(domains{r}(1)) ...
                    && str2num(combstr{i}(2)) <= str2num(domains{r}(2))
                str = [str  '+w' domains{r} '*' culturemedium{c}(1) '' combstr{i} '_' domains{r}];
            end
        end
        if i<15
            str = [str  '...\n'];
        end
    end
    
    % offset to cope with zero measurements in log space
    str = [str  ') + offset);'];
end

%% Remaining definitions needed for AMICI
str = [str '\n\nmodel.sym.sigma_y = sym(ones(' num2str(15*length(culturemedium)) ',1));\n'];
str = [str 'model.sym.x0 = sym(zeros(' num2str(length(statesstr)*length(culturemedium)) ',1));\n'];
str = [str 'model.sym.k = offset;\n'];


fprintf(fid,str);
fclose(fid);