function [indBest_BIC, indSmallest_BIC] = reduce_domainModel(foldername,varargin)
% Function which returns the index indBest: minimal BIC and 
% indSmallest: delta BIC < 10 and least number of domains

if nargin > 1
    saveFigures = varargin{1};
else
	saveFigures = false;
end

load([foldername '/findOffset/results_15domains_CAL311_319_all_WT_offset1em1'],...
    'parameters','DA')

n_data = sum(sum(sum(~isnan(DA.my))));
fullBIC = parameters.MS.BIC(1);

bestBIC = fullBIC;
load domains
allBICs = nan(length(domains),1);

for ind = 1:length(domains)
    try
        load([foldername '/results_' modelnames{ind}],'parameters')
        allBICs(ind) = -2*parameters.MS.logPost(1) + log(n_data)*(parameters.number+1);%parameters.MS.BIC(1);
    end
end

doReduction = false;
if doReduction
    allDomains = {'00','01','02','03','10','11','12','13','20','21','22',...
    '23','30','31','32'};
    requiredDomains = {'32'};

    %% Which of the domains can NOT be removed?
    tmpBIC = nan(14,1);
    for i = 1:14
        ind = findDomainIndex(allDomains([1:i-1,i+1:15]),domains);
        tmpBIC(i) = allBICs(ind);
        indices(i) = ind;
    end
    
    disp('cannot be removed:')
    allDomains(tmpBIC>fullBIC+10)
    requiredDomains = sortDomains([allDomains(tmpBIC>fullBIC+10),requiredDomains]);
    
    %% Forward selection step with 03, 30, and 32, either 13 or 23 required!
    candidates = {'13','23'};
    tmpBIC = nan(length(candidates),1);
    for i = 1:length(candidates)
        ind = findDomainIndex(sortDomains([requiredDomains,candidates(i)]),domains);
        tmpBIC(i) = allBICs(ind);
    end
    [~,imin] = min(tmpBIC);
    
    disp(['add ' candidates{imin}])
    requiredDomains = sortDomains([requiredDomains,candidates{imin}]);
    
    if min(tmpBIC)<bestBIC
        bestBIC = min(tmpBIC);
        ind_bestBIC = findDomainIndex(sortDomains(requiredDomains),domains);
    end
    %% Forward selection step
    candidates = allDomains(~ismember(allDomains,requiredDomains));
    
    tmpBIC = nan(length(candidates),1);
    for i = 1:length(candidates)
        try
            ind = findDomainIndex(sortDomains([requiredDomains,candidates{i}]),domains);
            load([foldername '_' modelnames{ind} '_offset1em1'],'parameters')
            tmpBIC(i) = parameters.MS.BIC(1);
        catch
            sortDomains([requiredDomains,candidates{i}])
            disp([modelnames{ind} ' not found with ind ' num2str(ind)])
        end
    end
    [~,imin] = min(tmpBIC);
    disp(['add ' candidates{imin}])
        
    requiredDomains = sortDomains([requiredDomains,candidates{imin}])
    
    if min(tmpBIC)<bestBIC
        bestBIC = min(tmpBIC);
        indBestBIC = findDomainIndex(sortDomains(requiredDomains),domains);
    end

    [bestBICAll,tmpind]=min(allBICs)
    find(allBICs-min(allBICs) <10) 
end

load_plot_settings
for ind = 1:length(domains)
    numDomains(ind) = length(domains{ind});
end

for ind = 1:15
    if ~isempty(allBICs(numDomains==ind))
        tmpBICs(ind) = min(allBICs(numDomains==ind));
    else
        tmpBICs(ind) = nan;
    end
end
tmpBICs(15) = fullBIC;

figure
plot(find(~isnan(tmpBICs)),tmpBICs(~isnan(tmpBICs))-min(tmpBICs),'o-',...
    'MarkerSize',3,'MarkerFaceColor',color.domains,'Color',color.domains); hold on;
plot(3:15,10*ones(length(3:15),1),':','Color',[0.5,0.5,0.5])
set(gca,'fontsize',8,'TickDir','out');
ylim([0,200])
xlim([3,15])
box off
ylabel('\Delta BIC','fontsize',fs)
xlabel('number of domains','fontsize',fs)
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5.5 3.5])
if saveFigures
    print('-depsc',['./figures/modelReduction_BIC']);
end

validDomainNum = find(tmpBICs-min(tmpBICs)<10);
[~,tmp_ind1] = min(allBICs(numDomains==validDomainNum(1)));
tmp_ind2 = find(numDomains==validDomainNum(1));
indSmallest_BIC = tmp_ind2(tmp_ind1);
[~,indBest_BIC] = min(allBICs);

disp(['Model index with Delta BIC < 10 and least number of domains: '....
    num2str(indSmallest_BIC)])
disp(['Model name: ' modelnames{indSmallest_BIC}])
disp(['Domains: '])
domains{indSmallest_BIC}

disp(['Model index with minimal BIC: '....
    num2str(indBest_BIC)])
disp(['Model name: ' modelnames{indBest_BIC}])
disp(['Domains: '])
domains{indBest_BIC}



end
