function [] = predict_inhibition(domainModelFile,varargin)

if nargin > 1
    saveFigures = varargin{1};
else
    saveFigures = false;
end

load_plot_settings

%% Find inhibitor effect by comparing inhibitor data with untreated data
% K27me2/K27me3 fraction steady state with inhibitor
load('CAL314315316_Inh.mat')
ind_tp = 5; % 16h
K27me3 = squeeze(sum(D.my(ind_tp,13+30:15+30,:),2));
K27me2 = squeeze(sum(D.my(ind_tp,9+30:12+30,:),2));

%figure
%K27me3s = squeeze(sum(D.my(1:end,13+30:15+30,:),2));
%K27me2s = squeeze(sum(D.my(1:end,9+30:12+30,:),2));
%plot(D.t,K27me3s,'k'); hold on;
%plot(D.t,K27me2s,'b'); hold on;
ratioInh = K27me3./K27me2;

load('CAL314315316_WT.mat')
K27me3 = squeeze(sum(D.my(ind_tp,13+30:15+30,:),2));
K27me2 = squeeze(sum(D.my(ind_tp,9+30:12+30,:),2));
ratioWT = K27me3./K27me2;

%figure
%K27me3s = squeeze(sum(D.my(1:end,13+30:15+30,:),2));
%K27me2s = squeeze(sum(D.my(1:end,9+30:12+30,:),2));
%plot(D.t,K27me3s,'k'); hold on;
%plot(D.t,K27me2s,'b'); hold on;

kappas_replicates = 1-ratioInh./ratioWT;
kappa = 1-mean(ratioInh./ratioWT);

disp(['average inhibition of ' num2str(kappa) '% +-' ...
    num2str(std(ratioInh./ratioWT))])

figure
subplot('Position',[0.2,0.5,0.6,0.45]);
b = bar([ratioWT,ratioInh]);
b(1).FaceColor = color.heavy;
b(2).FaceColor = [219,36,23]./255;
box off
ylim([0,0.4])
set(gca,'TickDir','out','FontSize',fs,'xticklabel','');
ylabel('K27me3/K27me2','FontSize',fs),
subplot('Position',[0.2,0.2,0.6,0.2]);
plot([1,2,3],kappas_replicates,'k.','MarkerSize',8);
xlim([0.5,3.5]);
ylim([0,1])
ylabel('\kappa','FontSize',fs),
set(gca,'TickDir','out','FontSize',fs,'xtick',[1,2,3])%,'xticklabel',{'CAL314','CAL315','CAL316'}),
box off
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5.5 3.5])
if saveFigures
    print('-dpdf','./figures/kappa_16h')
end

%% Model predictions using one kappa
figure
load('./results/findOffset/results_globalDemeth_CAL311_319_all_WT_offset1em1',...
    'parameters','options','sim_light','sim_all')
options.ami = amioption();
xiA = parameters.MS.par(1:options.llh.n_theta,1);
xiB = xiA;
indRemove = [23,25,27]; %2x -> 3x
disp('changed rates:')
parameters.name{indRemove}
color.global_prediction = [166,27,15
    208,34,21;
    251,57,39;
    243,146,145;
    color.heavy*255]./255;
xiB(indRemove) = xiA(indRemove)+log10(1-kappa);
sol_all = simulate_histones_all_withpreequ_inhibitor...
    (linspace(D.t(1),D.t(end)+1)+3,...
    xiA,xiB,options.llh.input,options.ami,sim_light,sim_all);
plotsim = ((exp(sol_all.y(:,13)))-options.llh.input + ...
    (exp(sol_all.y(:,14)))-options.llh.input + ...
    (exp(sol_all.y(:,15)))-options.llh.input)*100;

yDashed = plotsim;
yDashed(5:5:length(yDashed)) = NaN;
plot(sol_all.t-3,yDashed,'-','LineWidth',1,...
    'Color',color.global); hold on;

load('CAL314315316_Inh.mat')
load_plot_settings
opt.plot.A.marker = '.';
opt.plot.A.markersize = 8;
opt.plot.A.color.data = 'k';
opt.plot.errorbarwidth = 1;
opt.plot.lw = 0.8;
tmp = squeeze(sum(D.my(:,13:15,:),2));
tdata = D.t;
myerrorbar_histones(tdata,mean(tmp')*100,std(tmp')*100,opt,'A'); hold on;
xlim([-4,18])
ylim([0,40])

load(domainModelFile)
options.ami = amioption();
xiA = parameters.MS.par(:,1);
xiB = xiA;
indRemove = [16,18,20]; %2x -> 3x
disp('changed rates:')
parameters.name{indRemove}
xiB(indRemove) = xiA(indRemove)+log10(1-kappa);
sol_all = simulate_histones_all_withpreequ_inhibitor...
    (linspace(D.t(1),D.t(end)+1)+3,...
    xiA,xiB,options.llh.input,options.ami,sim_light,sim_all);
plotsim = ((exp(sol_all.y(:,13)))-options.llh.input + ...
    (exp(sol_all.y(:,14)))-options.llh.input + ...
    (exp(sol_all.y(:,15)))-options.llh.input)*100;
plot(sol_all.t-3,plotsim,'-','LineWidth',1,...
    'Color',color.domains); hold on;

myerrorbar_histones(tdata,mean(tmp')*100,std(tmp')*100,opt,'A'); hold on;
if labelFlag
    xlabel('Time (hr)');
    ylabel('K27me3 levels of generation 1')
end
xlim([-4,18])
ylim([0,30])
box off
set(gca,'FontSize',fs,'TickDir','out','xtick',[-3,0,4,8,12,16]);
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5.5 3.5])
if saveFigures
    print('-dpdf','./figures/prediction_inhibitor_onekappa')
end

%% Model predictions for global model using range of kappa
if false
    figure
    load('./results/findOffset/results_globalDemeth_CAL311_319_all_WT_offset1em1',...
        'parameters','options','sim_light','sim_all')
    options.ami = amioption();
    xiA = parameters.MS.par(1:options.llh.n_theta,1);
    xiB = xiA;
    indRemove = [23,25,27]; %2x -> 3x
    disp('changed rates:')
    parameters.name{indRemove}
    kappa = 1-[0,0.1,0.25,0.5,1];
    color.global_prediction = [166,27,15
        208,34,21;
        251,57,39;
        243,146,145;
        color.heavy*255]./255;
    for iKappa = 1:length(kappa)
        xiB(indRemove) = xiA(indRemove)+log10(1-kappa(iKappa));
        sol_all = simulate_histones_all_withpreequ_inhibitor...
            (linspace(D.t(1),D.t(end)+1)+3,...
            xiA,xiB,options.llh.input,options.ami,sim_light,sim_all);
        plotsim = ((exp(sol_all.y(:,13)))-options.llh.input + ...
            (exp(sol_all.y(:,14)))-options.llh.input + ...
            (exp(sol_all.y(:,15)))-options.llh.input)*100;
        llh(iKappa) =  plot(sol_all.t-3,plotsim,'LineWidth',1,...
            'Color',color.global_prediction(iKappa,:)); hold on;
        if iKappa > 2
            text(17.2,plotsim(end),['\kappa = ' num2str(kappa(iKappa))],...
                'Color',color.global_prediction(iKappa,:),'FontSize',fs);
        elseif iKappa == 1
            text(17.2,plotsim(end)-0.7,['\kappa = ' num2str(kappa(iKappa))],...
                'Color',color.global_prediction(iKappa,:),'FontSize',fs);
        elseif iKappa == 2
            text(17.2,plotsim(end)+0.7,['\kappa = ' num2str(kappa(iKappa))],...
                'Color',color.global_prediction(iKappa,:),'FontSize',fs);
        end
    end
    load('CAL314315316_Inh.mat')
    opt.plot.A.marker = '.';
    opt.plot.A.markersize = 8;
    opt.plot.A.color.data = 'k';
    opt.plot.errorbarwidth = 1;
    opt.plot.lw = 0.8;
    tmp = squeeze(sum(D.my(:,13:15,:),2));
    tdata = D.t;
    myerrorbar_histones(tdata,mean(tmp')*100,std(tmp')*100,opt,'A'); hold on;
    xlim([-4,18])
    ylim([0,40])
    xlabel('time [h]');
    box off
    set(gca,'FontSize',fs,'TickDir','out','xtick',[-3,0,4,8,16]);
    set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 4 4])
    if saveFigures
        print('-dpdf','./figures/global_prediction_inhibitor')
    end
    %% Domain model
    figure
    load(domainModelFile)
    options.ami = amioption();
    xiA = parameters.MS.par(:,1);
    xiB = xiA;
    indRemove = [16,18,20]; %2x -> 3x
    disp('changed rates:')
    parameters.name{indRemove}
    
    for iKappa = 1:length(kappa)
        xiB(indRemove) = xiA(indRemove)+log10(1-kappa(iKappa));
        sol_all = simulate_histones_all_withpreequ_inhibitor...
            (linspace(D.t(1),D.t(end)+1)+3,...
            xiA,xiB,options.llh.input,options.ami,sim_light,sim_all);
        plotsim = ((exp(sol_all.y(:,13)))-options.llh.input + ...
            (exp(sol_all.y(:,14)))-options.llh.input + ...
            (exp(sol_all.y(:,15)))-options.llh.input)*100;
        llh(iKappa) =  plot(sol_all.t-3,plotsim,'-','LineWidth',1,...
            'Color',color.global_prediction(iKappa,:)); hold on;
        if iKappa > 2
            text(17.2,plotsim(end),['\kappa = ' num2str(kappa(iKappa))],...
                'Color',color.global_prediction(iKappa,:),'FontSize',fs);
        elseif iKappa == 1
            text(17.2,plotsim(end)-0.7,['\kappa = ' num2str(kappa(iKappa))],...
                'Color',color.global_prediction(iKappa,:),'FontSize',fs);
        elseif iKappa == 2
            text(17.2,plotsim(end)+0.2,['\kappa = ' num2str(kappa(iKappa))],...
                'Color',color.global_prediction(iKappa,:),'FontSize',fs);
        end
    end
    myerrorbar_histones(tdata,mean(tmp')*100,std(tmp')*100,opt,'A'); hold on;
    xlabel('time [h]');
    xlim([-4,18])
    ylim([0,40])
    box off
    set(gca,'FontSize',fs,'TickDir','out','xtick',[-3,0,4,8,16]);
    set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 4 4])
    if saveFigures
        print('-dpdf','./figures/domain_prediction_inhibitor')
    end
end
