function fh = modelSelection_untreated_recovery(indDomain,saveFigures)

load domains
load diffs

for ind = 1:length(diffs)
    load(['./results/forwSel_' modelnames{indDomain} '_untr_rec_diff' ...
        diffnames{ind}],...
        'parameters');
    allBICs(ind) = parameters.MS.BIC(1);
    numDiffs(ind) = length(diffs{ind});
end

load(['./results/results_' modelnames{indDomain} '_untr_rec_no'],...
        'parameters');
    
tmpBICs(1) = parameters.MS.BIC(1);
for ind = 1:6
    if ~isempty(allBICs(numDiffs==ind))
        tmpBICs(ind+1) = min(allBICs(numDiffs==ind));
    else
        tmpBICs(ind+1) = nan;
    end
end

load_plot_settings
fh = figure;
plot(0:6,tmpBICs-min(tmpBICs),'-o','MarkerSize',3,...
    'MarkerFaceColor',color.domains,'Color',color.domains);
set(gca,'fontsize',8,'TickDir','out');
box off
xlabel('number of differences')
ylabel('\Delta BIC')
set(gcf, 'PaperUnits','centimeters', 'PaperPosition',[0 0 5 7])
if saveFigures
    print('-dpdf','-r1200',['./figures/histone_modelselection_untreatedRecovery'])
end

